/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.spring3.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.attr.AbstractStandardSingleAttributeModifierAttrProcessor;

public final class SpringActionAttrProcessor
extends AbstractStandardSingleAttributeModifierAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1000;
    public static final String ATTR_NAME = "action";

    public SpringActionAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1000;
    }

    protected String getTargetAttributeName(Arguments arguments, Element element, String attributeName) {
        return ATTR_NAME;
    }

    protected String getTargetAttributeValue(Arguments arguments, Element element, String attributeName) {
        String attributeValue = super.getTargetAttributeValue(arguments, element, attributeName);
        String httpMethod = element.getAttributeValueFromNormalizedName("method");
        return RequestDataValueProcessorUtils.processAction(arguments.getConfiguration(), (IProcessingContext)arguments, attributeValue, httpMethod);
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return false;
    }

    protected void doAdditionalProcess(Arguments arguments, Element element, String attributeName) {
        Map<String, String> extraHiddenFields;
        if ("form".equals(element.getNormalizedName()) && (extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields(arguments.getConfiguration(), (IProcessingContext)arguments)) != null && extraHiddenFields.size() > 0) {
            for (Map.Entry<String, String> extraHiddenField : extraHiddenFields.entrySet()) {
                Element extraHiddenElement = new Element("input");
                extraHiddenElement.setAttribute("type", "hidden");
                extraHiddenElement.setAttribute("name", extraHiddenField.getKey());
                extraHiddenElement.setAttribute("value", extraHiddenField.getValue());
                element.insertChild(element.numChildren(), (Node)extraHiddenElement);
            }
        }
    }
}

