/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.util;

import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    public static final String ALL_FIELDS = "*";
    public static final String GLOBAL_EXPRESSION = "global";
    public static final String ALL_EXPRESSION = "all";

    public static boolean hasErrors(Arguments arguments, String field) {
        return FieldUtils.hasErrors(arguments.getConfiguration(), (IProcessingContext)arguments, field);
    }

    public static boolean hasAnyErrors(Arguments arguments) {
        return FieldUtils.hasAnyErrors(arguments.getConfiguration(), (IProcessingContext)arguments);
    }

    public static boolean hasGlobalErrors(Arguments arguments) {
        return FieldUtils.hasGlobalErrors(arguments.getConfiguration(), (IProcessingContext)arguments);
    }

    public static boolean hasErrors(Configuration configuration, IProcessingContext processingContext, String field) {
        return FieldUtils.checkErrors(configuration, processingContext, FieldUtils.convertToFieldExpression(field));
    }

    public static boolean hasAnyErrors(Configuration configuration, IProcessingContext processingContext) {
        return FieldUtils.checkErrors(configuration, processingContext, ALL_EXPRESSION);
    }

    public static boolean hasGlobalErrors(Configuration configuration, IProcessingContext processingContext) {
        return FieldUtils.checkErrors(configuration, processingContext, GLOBAL_EXPRESSION);
    }

    public static List<String> errors(Arguments arguments, String field) {
        return FieldUtils.computeErrors(arguments.getConfiguration(), (IProcessingContext)arguments, field);
    }

    public static List<String> errors(Configuration configuration, IProcessingContext processingContext, String field) {
        return FieldUtils.computeErrors(configuration, processingContext, FieldUtils.convertToFieldExpression(field));
    }

    public static List<String> errors(Configuration configuration, IProcessingContext processingContext) {
        return FieldUtils.computeErrors(configuration, processingContext, ALL_EXPRESSION);
    }

    public static List<String> globalErrors(Configuration configuration, IProcessingContext processingContext) {
        return FieldUtils.computeErrors(configuration, processingContext, GLOBAL_EXPRESSION);
    }

    private static List<String> computeErrors(Configuration configuration, IProcessingContext processingContext, String fieldExpression) {
        BindStatus bindStatus = FieldUtils.getBindStatus(configuration, processingContext, fieldExpression);
        if (bindStatus == null) {
            throw new TemplateProcessingException("A BindStatus couldn't be obtained for expression '" + fieldExpression + "'. Maybe a RequestContext has " + "not been registered, or there is no available binding for the object the expression references " + "(e.g. if this expression selects a field inside a form, the form-backing bean might not have been " + "referenced at the <form> tag with a 'th:object' attribute)");
        }
        String[] errorCodes = bindStatus.getErrorMessages();
        return Arrays.asList(errorCodes);
    }

    public static String idFromName(String fieldName) {
        return StringUtils.deleteAny((String)fieldName, (String)"[]");
    }

    private static String convertToFieldExpression(String field) {
        if (field == null) {
            return null;
        }
        if (field.trim().startsWith(ALL_FIELDS) || field.trim().startsWith("$")) {
            return field;
        }
        StringBuilder strBuilder = new StringBuilder(20);
        strBuilder.append('*');
        strBuilder.append('{');
        strBuilder.append(field);
        strBuilder.append('}');
        return strBuilder.toString();
    }

    private static boolean checkErrors(Configuration configuration, IProcessingContext processingContext, String expression) {
        BindStatus bindStatus = FieldUtils.getBindStatus(configuration, processingContext, expression);
        if (bindStatus == null) {
            throw new TemplateProcessingException("A BindStatus couldn't be obtained for expression '" + expression + "'. Maybe a RequestContext has " + "not been registered, or there is no available binding for the object the expression references " + "(e.g. if this expression selects a field inside a form, the form-backing bean might not have been " + "referenced at the <form> tag with a 'th:object' attribute)");
        }
        return bindStatus.isError();
    }

    @Deprecated
    public static BindStatus getBindStatus(Arguments arguments, String expression, boolean allowAllFields) {
        return FieldUtils.getBindStatus(arguments.getConfiguration(), (IProcessingContext)arguments, expression);
    }

    @Deprecated
    public static BindStatus getBindStatus(Configuration configuration, IProcessingContext processingContext, String expression, boolean allowAllFields) {
        return FieldUtils.getBindStatus(configuration, processingContext, expression);
    }

    public static BindStatus getBindStatus(Configuration configuration, IProcessingContext processingContext, String expression) {
        Validate.notNull((Object)expression, (String)"Expression cannot be null");
        if (GLOBAL_EXPRESSION.equals(expression) || ALL_EXPRESSION.equals(expression) || ALL_FIELDS.equals(expression)) {
            return FieldUtils.getBindStatus(configuration, processingContext, "*{" + expression + "}");
        }
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((Configuration)configuration);
        IStandardExpression expressionObj = expressionParser.parseExpression(configuration, processingContext, expression);
        if (expressionObj == null) {
            throw new TemplateProcessingException("Expression \"" + expression + "\" is not valid: cannot perform Spring bind");
        }
        if (expressionObj instanceof SelectionVariableExpression) {
            String bindExpression = ((SelectionVariableExpression)expressionObj).getExpression();
            return FieldUtils.getBindStatusFromParsedExpression(configuration, processingContext, true, bindExpression);
        }
        if (expressionObj instanceof VariableExpression) {
            String bindExpression = ((VariableExpression)expressionObj).getExpression();
            return FieldUtils.getBindStatusFromParsedExpression(configuration, processingContext, false, bindExpression);
        }
        throw new TemplateProcessingException("Expression \"" + expression + "\" is not valid: only variable expressions ${...} or " + "selection expressions *{...} are allowed in Spring field bindings");
    }

    public static BindStatus getBindStatusFromParsedExpression(Configuration configuration, IProcessingContext processingContext, boolean useSelectionAsRoot, String expression) {
        RequestContext requestContext = (RequestContext)processingContext.getContext().getVariables().get((Object)"springRequestContext");
        if (requestContext == null) {
            return null;
        }
        String completeExpression = FieldUtils.validateAndGetValueExpression(processingContext, useSelectionAsRoot, expression);
        if (completeExpression == null) {
            return null;
        }
        if (FieldUtils.isBound(requestContext, completeExpression)) {
            return new BindStatus(requestContext, completeExpression, false);
        }
        return null;
    }

    private static String validateAndGetValueExpression(IProcessingContext processingContext, boolean useSelectionAsRoot, String expression) {
        if (useSelectionAsRoot) {
            String boundObjectExpression;
            VariableExpression boundObjectValue = (VariableExpression)processingContext.getLocalVariable("springBoundObjectExpression");
            if (boundObjectValue == null) {
                boundObjectValue = (VariableExpression)processingContext.getLocalVariable("springFormCommandValue");
            }
            String string = boundObjectExpression = boundObjectValue == null ? null : boundObjectValue.getExpression();
            if (GLOBAL_EXPRESSION.equals(expression)) {
                if (boundObjectExpression == null) {
                    return null;
                }
                return boundObjectExpression;
            }
            if (ALL_EXPRESSION.equals(expression) || ALL_FIELDS.equals(expression)) {
                if (boundObjectExpression == null) {
                    return null;
                }
                return boundObjectExpression + '.' + ALL_FIELDS;
            }
            if (boundObjectExpression == null) {
                return expression;
            }
            return boundObjectExpression + '.' + expression;
        }
        return expression;
    }

    private static boolean isBound(RequestContext requestContext, String expression) {
        int dotPos = expression.indexOf(46);
        String beanName = dotPos == -1 ? expression : expression.substring(0, dotPos);
        return requestContext.getErrors(beanName, false) != null;
    }

    private FieldUtils() {
    }
}

