/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.Clock;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.chrono.HijrahDate;
import org.threeten.bp.chrono.HijrahEra;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;

public final class HijrahChronology
extends Chronology
implements Serializable {
    public static final HijrahChronology INSTANCE = new HijrahChronology();
    public static final Era ERA_BEFORE_AH = HijrahEra.BEFORE_AH;
    public static final Era ERA_AH = HijrahEra.AH;
    private static final long serialVersionUID = 3127340209035924785L;
    private static final HashMap<String, String[]> ERA_NARROW_NAMES = new HashMap();
    private static final HashMap<String, String[]> ERA_SHORT_NAMES = new HashMap();
    private static final HashMap<String, String[]> ERA_FULL_NAMES = new HashMap();
    private static final String FALLBACK_LANGUAGE = "en";

    private HijrahChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Hijrah";
    }

    @Override
    public String getCalendarType() {
        return "islamicc";
    }

    public HijrahDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return (HijrahDate)super.date(era, yearOfEra, month, dayOfMonth);
    }

    public HijrahDate date(int prolepticYear, int month, int dayOfMonth) {
        return HijrahDate.of(prolepticYear, month, dayOfMonth);
    }

    public HijrahDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return (HijrahDate)super.dateYearDay(era, yearOfEra, dayOfYear);
    }

    public HijrahDate dateYearDay(int prolepticYear, int dayOfYear) {
        return HijrahDate.of(prolepticYear, 1, 1).plusDays(dayOfYear - 1);
    }

    public HijrahDate date(TemporalAccessor temporal) {
        if (temporal instanceof HijrahDate) {
            return (HijrahDate)temporal;
        }
        return HijrahDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    public HijrahDate dateNow() {
        return (HijrahDate)super.dateNow();
    }

    public HijrahDate dateNow(ZoneId zone) {
        return (HijrahDate)super.dateNow(zone);
    }

    public HijrahDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return (HijrahDate)super.dateNow(clock);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return HijrahDate.isLeapYear(prolepticYear);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof HijrahEra)) {
            throw new DateTimeException("Era must be HijrahEra");
        }
        return era == HijrahEra.AH ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public Era eraOf(int eraValue) {
        switch (eraValue) {
            case 0: {
                return HijrahEra.BEFORE_AH;
            }
            case 1: {
                return HijrahEra.AH;
            }
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(HijrahEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    static {
        ERA_NARROW_NAMES.put(FALLBACK_LANGUAGE, new String[]{"BH", "HE"});
        ERA_SHORT_NAMES.put(FALLBACK_LANGUAGE, new String[]{"B.H.", "H.E."});
        ERA_FULL_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Before Hijrah", "Hijrah Era"});
    }
}

