/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalUnit;

public abstract class DefaultInterfaceChronoLocalDateTime<D extends ChronoLocalDate<D>>
extends DefaultInterfaceTemporal
implements ChronoLocalDateTime<D> {
    @Override
    public ChronoLocalDateTime<D> with(TemporalAdjuster adjuster) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.with(adjuster));
    }

    @Override
    public ChronoLocalDateTime<D> plus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.plus(amount));
    }

    @Override
    public ChronoLocalDateTime<D> minus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.minus(amount));
    }

    @Override
    public ChronoLocalDateTime<D> minus(long amountToSubtract, TemporalUnit unit) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.minus(amountToSubtract, unit));
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)this.toLocalDate().getChronology();
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (query == TemporalQueries.localDate()) {
            return (R)LocalDate.ofEpochDay(this.toLocalDate().toEpochDay());
        }
        if (query == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        return super.query(query);
    }

    @Override
    public Instant toInstant(ZoneOffset offset) {
        return Instant.ofEpochSecond(this.toEpochSecond(offset), this.toLocalTime().getNano());
    }

    @Override
    public long toEpochSecond(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        long epochDay = this.toLocalDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return secs -= (long)offset.getTotalSeconds();
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> other) {
        int cmp = this.toLocalDate().compareTo(other.toLocalDate());
        if (cmp == 0 && (cmp = this.toLocalTime().compareTo(other.toLocalTime())) == 0) {
            cmp = this.toLocalDate().getChronology().compareTo(other.toLocalDate().getChronology());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<?> other) {
        long otherEpDay;
        long thisEpDay = this.toLocalDate().toEpochDay();
        return thisEpDay > (otherEpDay = other.toLocalDate().toEpochDay()) || thisEpDay == otherEpDay && this.toLocalTime().toNanoOfDay() > other.toLocalTime().toNanoOfDay();
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<?> other) {
        long otherEpDay;
        long thisEpDay = this.toLocalDate().toEpochDay();
        return thisEpDay < (otherEpDay = other.toLocalDate().toEpochDay()) || thisEpDay == otherEpDay && this.toLocalTime().toNanoOfDay() < other.toLocalTime().toNanoOfDay();
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<?> other) {
        return this.toLocalTime().toNanoOfDay() == other.toLocalTime().toNanoOfDay() && this.toLocalDate().toEpochDay() == other.toLocalDate().toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDateTime) {
            return this.compareTo((ChronoLocalDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDate().hashCode() ^ this.toLocalTime().hashCode();
    }

    @Override
    public String toString() {
        return this.toLocalDate().toString() + 'T' + this.toLocalTime().toString();
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

