/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.Clock;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.Month;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.Ser;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatters;
import org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.ISOChrono;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.zone.ZoneRules;

public final class OffsetDate
extends DefaultInterfaceTemporalAccessor
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDate>,
Serializable {
    public static final OffsetDate MIN = LocalDate.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetDate MAX = LocalDate.MAX.atOffset(ZoneOffset.MIN);
    private static final long serialVersionUID = -4382054179074397774L;
    private final LocalDate date;
    private final ZoneOffset offset;

    public static OffsetDate now() {
        return OffsetDate.now(Clock.systemDefaultZone());
    }

    public static OffsetDate now(ZoneId zone) {
        return OffsetDate.now(Clock.system(zone));
    }

    public static OffsetDate now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return OffsetDate.ofInstant(now, clock.getZone().getRules().getOffset(now));
    }

    public static OffsetDate of(LocalDate date, ZoneOffset offset) {
        return new OffsetDate(date, offset);
    }

    public static OffsetDate ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        long epochSec = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        long epochDay = Jdk8Methods.floorDiv(epochSec, 86400L);
        LocalDate date = LocalDate.ofEpochDay(epochDay);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate from(TemporalAccessor temporal) {
        if (temporal instanceof OffsetDate) {
            return (OffsetDate)temporal;
        }
        try {
            LocalDate date = LocalDate.from(temporal);
            ZoneOffset offset = ZoneOffset.from(temporal);
            return new OffsetDate(date, offset);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain OffsetDate from TemporalAccessor: " + temporal.getClass(), ex);
        }
    }

    public static OffsetDate parse(CharSequence text) {
        return OffsetDate.parse(text, DateTimeFormatters.isoOffsetDate());
    }

    public static OffsetDate parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, OffsetDate.class);
    }

    private OffsetDate(LocalDate date, ZoneOffset offset) {
        this.date = Objects.requireNonNull(date, "date");
        this.offset = Objects.requireNonNull(offset, "offset");
    }

    private OffsetDate with(LocalDate date, ZoneOffset offset) {
        if (this.date == date && this.offset.equals(offset)) {
            return this;
        }
        return new OffsetDate(date, offset);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return ((ChronoField)field).isDateField() || field == ChronoField.OFFSET_SECONDS;
        }
        return field != null && field.doIsSupported(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.date.range(field);
        }
        return field.doRange(this);
    }

    @Override
    public int get(TemporalField field) {
        return super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.date.getLong(field);
        }
        return field.doGet(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDate withOffset(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        return this.with(this.date, offset);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonthValue() {
        return this.date.getMonthValue();
    }

    public Month getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    @Override
    public OffsetDate with(TemporalAdjuster adjuster) {
        if (adjuster instanceof LocalDate) {
            return this.with((LocalDate)adjuster, this.offset);
        }
        if (adjuster instanceof ZoneOffset) {
            return this.with(this.date, (ZoneOffset)adjuster);
        }
        if (adjuster instanceof OffsetDate) {
            return (OffsetDate)adjuster;
        }
        return (OffsetDate)adjuster.adjustInto(this);
    }

    @Override
    public OffsetDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                ChronoField f = (ChronoField)field;
                return this.with(this.date, ZoneOffset.ofTotalSeconds(f.checkValidIntValue(newValue)));
            }
            return this.with(this.date.with(field, newValue), this.offset);
        }
        return field.doWith(this, newValue);
    }

    public OffsetDate withYear(int year) {
        return this.with(this.date.withYear(year), this.offset);
    }

    public OffsetDate withMonth(int month) {
        return this.with(this.date.withMonth(month), this.offset);
    }

    public OffsetDate withDayOfMonth(int dayOfMonth) {
        return this.with(this.date.withDayOfMonth(dayOfMonth), this.offset);
    }

    public OffsetDate withDayOfYear(int dayOfYear) {
        return this.with(this.date.withDayOfYear(dayOfYear), this.offset);
    }

    @Override
    public OffsetDate plus(TemporalAdder adder) {
        return (OffsetDate)adder.addTo(this);
    }

    @Override
    public OffsetDate plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.date.plus(amountToAdd, unit), this.offset);
        }
        return unit.doPlus(this, amountToAdd);
    }

    public OffsetDate plusYears(long years) {
        return this.with(this.date.plusYears(years), this.offset);
    }

    public OffsetDate plusMonths(long months) {
        return this.with(this.date.plusMonths(months), this.offset);
    }

    public OffsetDate plusWeeks(long weeks) {
        return this.with(this.date.plusWeeks(weeks), this.offset);
    }

    public OffsetDate plusDays(long days) {
        return this.with(this.date.plusDays(days), this.offset);
    }

    @Override
    public OffsetDate minus(TemporalSubtractor subtractor) {
        return (OffsetDate)subtractor.subtractFrom(this);
    }

    @Override
    public OffsetDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public OffsetDate minusYears(long years) {
        return this.with(this.date.minusYears(years), this.offset);
    }

    public OffsetDate minusMonths(long months) {
        return this.with(this.date.minusMonths(months), this.offset);
    }

    public OffsetDate minusWeeks(long weeks) {
        return this.with(this.date.minusWeeks(weeks), this.offset);
    }

    public OffsetDate minusDays(long days) {
        return this.with(this.date.minusDays(days), this.offset);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chrono()) {
            return (R)ISOChrono.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (query == TemporalQueries.offset() || query == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        return super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds()).with(ChronoField.EPOCH_DAY, this.getDate().toEpochDay());
    }

    @Override
    public long periodUntil(Temporal endDate, TemporalUnit unit) {
        if (!(endDate instanceof OffsetDate)) {
            Objects.requireNonNull(endDate, "endDate");
            throw new DateTimeException("Unable to calculate period between objects of two different types");
        }
        if (unit instanceof ChronoUnit) {
            OffsetDate end = (OffsetDate)endDate;
            long offsetDiff = end.offset.getTotalSeconds() - this.offset.getTotalSeconds();
            LocalDate endLocal = end.date.plusDays(Jdk8Methods.floorDiv(-offsetDiff, 86400L));
            return this.date.periodUntil(endLocal, unit);
        }
        return unit.between(this, endDate).getAmount();
    }

    public OffsetDateTime atTime(LocalTime time) {
        return OffsetDateTime.of(this.date, time, this.offset);
    }

    private long toEpochSecond() {
        long epochDay = this.date.toEpochDay();
        long secs = epochDay * 86400L;
        return secs - (long)this.offset.getTotalSeconds();
    }

    @Override
    public int compareTo(OffsetDate other) {
        if (this.offset.equals(other.offset)) {
            return this.date.compareTo(other.date);
        }
        int compare = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (compare == 0) {
            compare = this.date.compareTo(other.date);
        }
        return compare;
    }

    public boolean isAfter(OffsetDate other) {
        return this.toEpochSecond() > other.toEpochSecond();
    }

    public boolean isBefore(OffsetDate other) {
        return this.toEpochSecond() < other.toEpochSecond();
    }

    public boolean isEqual(OffsetDate other) {
        return this.toEpochSecond() == other.toEpochSecond();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OffsetDate) {
            OffsetDate other = (OffsetDate)obj;
            return this.date.equals(other.date) && this.offset.equals(other.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.date.toString() + this.offset.toString();
    }

    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.print(this);
    }

    private Object writeReplace() {
        return new Ser(65, this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput out) throws IOException {
        this.date.writeExternal(out);
        this.offset.writeExternal(out);
    }

    static OffsetDate readExternal(DataInput in) throws IOException {
        LocalDate date = LocalDate.readExternal(in);
        ZoneOffset offset = ZoneOffset.readExternal(in);
        return OffsetDate.of(date, offset);
    }
}

