/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.util.Comparator;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoZonedDateTime<C extends Chrono<C>>
extends Temporal,
Comparable<ChronoZonedDateTime<?>> {
    public static final Comparator<ChronoZonedDateTime<?>> INSTANT_COMPARATOR = new Comparator<ChronoZonedDateTime<?>>(){

        @Override
        public int compare(ChronoZonedDateTime<?> datetime1, ChronoZonedDateTime<?> datetime2) {
            int cmp = Long.compare(datetime1.toEpochSecond(), datetime2.toEpochSecond());
            if (cmp == 0) {
                cmp = Long.compare(datetime1.getTime().toNanoOfDay(), datetime2.getTime().toNanoOfDay());
            }
            return cmp;
        }
    };

    public ChronoLocalDate<C> getDate();

    public LocalTime getTime();

    public ChronoLocalDateTime<C> getDateTime();

    public ZoneOffset getOffset();

    public ZoneId getZone();

    public ChronoZonedDateTime<C> withEarlierOffsetAtOverlap();

    public ChronoZonedDateTime<C> withLaterOffsetAtOverlap();

    public ChronoZonedDateTime<C> withZoneSameLocal(ZoneId var1);

    public ChronoZonedDateTime<C> withZoneSameInstant(ZoneId var1);

    @Override
    public ChronoZonedDateTime<C> with(TemporalAdjuster var1);

    @Override
    public ChronoZonedDateTime<C> with(TemporalField var1, long var2);

    @Override
    public ChronoZonedDateTime<C> plus(TemporalAdder var1);

    @Override
    public ChronoZonedDateTime<C> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoZonedDateTime<C> minus(TemporalSubtractor var1);

    @Override
    public ChronoZonedDateTime<C> minus(long var1, TemporalUnit var3);

    public Instant toInstant();

    public long toEpochSecond();

    @Override
    public int compareTo(ChronoZonedDateTime<?> var1);

    public boolean isBefore(ChronoZonedDateTime<?> var1);

    public boolean isAfter(ChronoZonedDateTime<?> var1);

    public boolean isEqual(ChronoZonedDateTime<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

