/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.util.Comparator;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoZonedDateTime;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoLocalDateTime<C extends Chrono<C>>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDateTime<?>> {
    public static final Comparator<ChronoLocalDateTime<?>> DATE_TIME_COMPARATOR = new Comparator<ChronoLocalDateTime<?>>(){

        @Override
        public int compare(ChronoLocalDateTime<?> datetime1, ChronoLocalDateTime<?> datetime2) {
            int cmp = Long.compare(datetime1.getDate().toEpochDay(), datetime2.getDate().toEpochDay());
            if (cmp == 0) {
                cmp = Long.compare(datetime1.getTime().toNanoOfDay(), datetime2.getTime().toNanoOfDay());
            }
            return cmp;
        }
    };

    public ChronoLocalDate<C> getDate();

    public LocalTime getTime();

    @Override
    public ChronoLocalDateTime<C> with(TemporalAdjuster var1);

    @Override
    public ChronoLocalDateTime<C> with(TemporalField var1, long var2);

    @Override
    public ChronoLocalDateTime<C> plus(TemporalAdder var1);

    @Override
    public ChronoLocalDateTime<C> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoLocalDateTime<C> minus(TemporalSubtractor var1);

    @Override
    public ChronoLocalDateTime<C> minus(long var1, TemporalUnit var3);

    public ChronoZonedDateTime<C> atZone(ZoneId var1);

    public Instant toInstant(ZoneOffset var1);

    public long toEpochSecond(ZoneOffset var1);

    @Override
    public int compareTo(ChronoLocalDateTime<?> var1);

    public boolean isAfter(ChronoLocalDateTime<?> var1);

    public boolean isBefore(ChronoLocalDateTime<?> var1);

    public boolean isEqual(ChronoLocalDateTime<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

