/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public abstract class DefaultInterfaceChronoLocalDateTime<C extends Chrono<C>>
extends DefaultInterfaceTemporal
implements ChronoLocalDateTime<C> {
    @Override
    public ChronoLocalDateTime<C> with(TemporalAdjuster adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoLocalDateTime(super.with(adjuster));
    }

    @Override
    public ChronoLocalDateTime<C> plus(TemporalAdder adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoLocalDateTime(super.plus(adjuster));
    }

    @Override
    public ChronoLocalDateTime<C> minus(TemporalSubtractor adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoLocalDateTime(super.minus(adjuster));
    }

    @Override
    public ChronoLocalDateTime<C> minus(long amountToSubtract, TemporalUnit unit) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoLocalDateTime(super.minus(amountToSubtract, unit));
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.getDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.getTime().toNanoOfDay());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chrono()) {
            return (R)this.getDate().getChrono();
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return super.query(query);
    }

    @Override
    public Instant toInstant(ZoneOffset offset) {
        return Instant.ofEpochSecond(this.toEpochSecond(offset), this.getTime().getNano());
    }

    @Override
    public long toEpochSecond(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        long epochDay = this.getDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.getTime().toSecondOfDay();
        return secs -= (long)offset.getTotalSeconds();
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> other) {
        int cmp = this.getDate().compareTo(other.getDate());
        if (cmp == 0 && (cmp = this.getTime().compareTo(other.getTime())) == 0) {
            cmp = ((Chrono)this.getDate().getChrono()).compareTo((Chrono<?>)other.getDate().getChrono());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<?> other) {
        long otherEpDay;
        long thisEpDay = this.getDate().toEpochDay();
        return thisEpDay > (otherEpDay = other.getDate().toEpochDay()) || thisEpDay == otherEpDay && this.getTime().toNanoOfDay() > other.getTime().toNanoOfDay();
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<?> other) {
        long otherEpDay;
        long thisEpDay = this.getDate().toEpochDay();
        return thisEpDay < (otherEpDay = other.getDate().toEpochDay()) || thisEpDay == otherEpDay && this.getTime().toNanoOfDay() < other.getTime().toNanoOfDay();
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<?> other) {
        return this.getTime().toNanoOfDay() == other.getTime().toNanoOfDay() && this.getDate().toEpochDay() == other.getDate().toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDateTime) {
            return this.compareTo((ChronoLocalDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDate().hashCode() ^ this.getTime().hashCode();
    }

    @Override
    public String toString() {
        return this.getDate().toString() + 'T' + this.getTime().toString();
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.print(this);
    }
}

