/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.ZoneId;
import org.threeten.bp.format.DateTimeBuilder;
import org.threeten.bp.format.DateTimeFormatSymbols;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.DateTimeParseContext;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.format.DateTimePrintContext;
import org.threeten.bp.format.DateTimePrintException;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.TemporalAccessor;

public final class DateTimeFormatter {
    private final DateTimeFormatterBuilder.CompositePrinterParser printerParser;
    private final Locale locale;
    private final DateTimeFormatSymbols symbols;
    private final Chrono<?> chrono;
    private final ZoneId zone;

    DateTimeFormatter(DateTimeFormatterBuilder.CompositePrinterParser printerParser, Locale locale, DateTimeFormatSymbols symbols, Chrono<?> chrono, ZoneId zone) {
        this.printerParser = Objects.requireNonNull(printerParser, "printerParser");
        this.locale = Objects.requireNonNull(locale, "locale");
        this.symbols = Objects.requireNonNull(symbols, "symbols");
        this.chrono = chrono;
        this.zone = zone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (this.locale.equals(locale)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, locale, this.symbols, this.chrono, this.zone);
    }

    public DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    public DateTimeFormatter withSymbols(DateTimeFormatSymbols symbols) {
        if (this.symbols.equals(symbols)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, symbols, this.chrono, this.zone);
    }

    public Chrono<?> getChrono() {
        return this.chrono;
    }

    public DateTimeFormatter withChrono(Chrono<?> chrono) {
        if (Objects.equals(this.chrono, chrono)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, this.symbols, chrono, this.zone);
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public DateTimeFormatter withZone(ZoneId zone) {
        if (Objects.equals(this.zone, zone)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, this.symbols, this.chrono, zone);
    }

    public String print(TemporalAccessor temporal) {
        StringBuilder buf = new StringBuilder(32);
        this.printTo(temporal, buf);
        return buf.toString();
    }

    public void printTo(TemporalAccessor temporal, Appendable appendable) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(appendable, "appendable");
        try {
            DateTimePrintContext context = new DateTimePrintContext(temporal, this);
            if (appendable instanceof StringBuilder) {
                this.printerParser.print(context, (StringBuilder)appendable);
            } else {
                StringBuilder buf = new StringBuilder(32);
                this.printerParser.print(context, buf);
                appendable.append(buf);
            }
        }
        catch (IOException ex) {
            throw new DateTimePrintException(ex.getMessage(), ex);
        }
    }

    public <T> T parse(CharSequence text, Class<T> type) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(type, "type");
        String str = text.toString();
        try {
            DateTimeBuilder builder = this.parseToBuilder(str).resolve();
            return builder.build(type);
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(str, ex);
        }
    }

    public TemporalAccessor parseBest(CharSequence text, Class<?> ... types) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(types, "types");
        if (types.length < 2) {
            throw new IllegalArgumentException("At least two types must be specified");
        }
        String str = text.toString();
        try {
            DateTimeBuilder builder = this.parseToBuilder(str).resolve();
            for (Class<?> type : types) {
                try {
                    return (TemporalAccessor)builder.build(type);
                }
                catch (RuntimeException ex) {
                }
            }
            throw new DateTimeException("Unable to convert parsed text to any specified type: " + Arrays.toString(types));
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(str, ex);
        }
    }

    private DateTimeParseException createError(String str, RuntimeException ex) {
        String abbr = str;
        if (abbr.length() > 64) {
            abbr = abbr.substring(0, 64) + "...";
        }
        return new DateTimeParseException("Text '" + abbr + "' could not be parsed: " + ex.getMessage(), str, 0, ex);
    }

    public DateTimeBuilder parseToBuilder(CharSequence text) {
        Objects.requireNonNull(text, "text");
        String str = text.toString();
        ParsePosition pos = new ParsePosition(0);
        DateTimeBuilder result = this.parseToBuilder(str, pos);
        if (result == null || pos.getErrorIndex() >= 0 || pos.getIndex() < str.length()) {
            String abbr = str;
            if (abbr.length() > 64) {
                abbr = abbr.substring(0, 64) + "...";
            }
            if (pos.getErrorIndex() >= 0) {
                throw new DateTimeParseException("Text '" + abbr + "' could not be parsed at index " + pos.getErrorIndex(), str, pos.getErrorIndex());
            }
            throw new DateTimeParseException("Text '" + abbr + "' could not be parsed, unparsed text found at index " + pos.getIndex(), str, pos.getIndex());
        }
        return result;
    }

    public DateTimeBuilder parseToBuilder(CharSequence text, ParsePosition position) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(position, "position");
        DateTimeParseContext context = new DateTimeParseContext(this);
        int pos = position.getIndex();
        pos = this.printerParser.parse(context, text, pos);
        if (pos < 0) {
            position.setErrorIndex(~pos);
            return null;
        }
        position.setIndex(pos);
        return context.toBuilder();
    }

    DateTimeFormatterBuilder.CompositePrinterParser toPrinterParser(boolean optional) {
        return this.printerParser.withOptional(optional);
    }

    public Format toFormat() {
        return new ClassicFormat(this, null);
    }

    public Format toFormat(Class<?> parseType) {
        Objects.requireNonNull(parseType, "parseType");
        return new ClassicFormat(this, parseType);
    }

    public String toString() {
        String pattern = this.printerParser.toString();
        return pattern.startsWith("[") ? pattern : pattern.substring(1, pattern.length() - 1);
    }

    static class ClassicFormat
    extends Format {
        private final DateTimeFormatter formatter;
        private final Class<?> parseType;

        public ClassicFormat(DateTimeFormatter formatter, Class<?> parseType) {
            this.formatter = formatter;
            this.parseType = parseType;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Objects.requireNonNull(obj, "obj");
            Objects.requireNonNull(toAppendTo, "toAppendTo");
            Objects.requireNonNull(pos, "pos");
            if (!(obj instanceof TemporalAccessor)) {
                throw new IllegalArgumentException("Format target must implement TemporalAccessor");
            }
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
            try {
                this.formatter.printTo((TemporalAccessor)obj, toAppendTo);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            return toAppendTo;
        }

        @Override
        public Object parseObject(String text) throws ParseException {
            Objects.requireNonNull(text, "text");
            try {
                if (this.parseType != null) {
                    return this.formatter.parse(text, this.parseType);
                }
                return this.formatter.parseToBuilder(text);
            }
            catch (DateTimeParseException ex) {
                throw new ParseException(ex.getMessage(), ex.getErrorIndex());
            }
            catch (RuntimeException ex) {
                throw (ParseException)new ParseException(ex.getMessage(), 0).initCause(ex);
            }
        }

        @Override
        public Object parseObject(String text, ParsePosition pos) {
            DateTimeBuilder builder;
            Objects.requireNonNull(text, "text");
            try {
                builder = this.formatter.parseToBuilder(text, pos);
            }
            catch (IndexOutOfBoundsException ex) {
                if (pos.getErrorIndex() < 0) {
                    pos.setErrorIndex(0);
                }
                return null;
            }
            if (builder == null) {
                if (pos.getErrorIndex() < 0) {
                    pos.setErrorIndex(0);
                }
                return null;
            }
            if (this.parseType == null) {
                return builder;
            }
            try {
                return builder.resolve().build(this.parseType);
            }
            catch (RuntimeException ex) {
                pos.setErrorIndex(0);
                return null;
            }
        }
    }
}

