/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalAdjusters;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;

public final class DateTimeBuilder
extends DefaultInterfaceTemporalAccessor
implements TemporalAccessor,
Cloneable {
    private Map<TemporalField, Long> otherFields;
    private final EnumMap<ChronoField, Long> standardFields = new EnumMap(ChronoField.class);
    private final List<Object> objects = new ArrayList<Object>(2);

    public DateTimeBuilder() {
    }

    public DateTimeBuilder(TemporalField field, long value) {
        this.addFieldValue(field, value);
    }

    public DateTimeBuilder(ZoneId zone, Chrono<?> chrono) {
        if (zone != null) {
            this.objects.add(zone);
        }
        if (chrono != null) {
            this.objects.add(chrono);
        }
    }

    public Map<TemporalField, Long> getFieldValueMap() {
        HashMap<TemporalField, Long> map = new HashMap<TemporalField, Long>(this.standardFields);
        if (this.otherFields != null) {
            map.putAll(this.otherFields);
        }
        return map;
    }

    public boolean containsFieldValue(TemporalField field) {
        Objects.requireNonNull(field, "field");
        return this.standardFields.containsKey(field) || this.otherFields != null && this.otherFields.containsKey(field);
    }

    public long getFieldValue(TemporalField field) {
        Objects.requireNonNull(field, "field");
        Long value = this.getFieldValue0(field);
        if (value == null) {
            throw new DateTimeException("Field not found: " + field);
        }
        return value;
    }

    private Long getFieldValue0(TemporalField field) {
        if (field instanceof ChronoField) {
            return this.standardFields.get(field);
        }
        if (this.otherFields != null) {
            return this.otherFields.get(field);
        }
        return null;
    }

    public long getValidFieldValue(TemporalField field) {
        long value = this.getFieldValue(field);
        return field.range().checkValidValue(value, field);
    }

    public DateTimeBuilder addFieldValue(TemporalField field, long value) {
        Objects.requireNonNull(field, "field");
        Long old = this.getFieldValue0(field);
        if (old != null && old != value) {
            throw new DateTimeException("Conflict found: " + field + " " + old + " differs from " + field + " " + value + ": " + this);
        }
        return this.putFieldValue0(field, value);
    }

    private DateTimeBuilder putFieldValue0(TemporalField field, long value) {
        if (field instanceof ChronoField) {
            this.standardFields.put((ChronoField)field, value);
        } else {
            if (this.otherFields == null) {
                this.otherFields = new LinkedHashMap<TemporalField, Long>();
            }
            this.otherFields.put(field, value);
        }
        return this;
    }

    public long removeFieldValue(TemporalField field) {
        Objects.requireNonNull(field, "field");
        Long value = null;
        if (field instanceof ChronoField) {
            value = this.standardFields.remove(field);
        } else if (this.otherFields != null) {
            value = this.otherFields.remove(field);
        }
        if (value == null) {
            throw new DateTimeException("Field not found: " + field);
        }
        return value;
    }

    public void removeFieldValues(TemporalField ... fields) {
        for (TemporalField field : fields) {
            if (field instanceof ChronoField) {
                this.standardFields.remove(field);
                continue;
            }
            if (this.otherFields == null) continue;
            this.otherFields.remove(field);
        }
    }

    public Long[] queryFieldValues(TemporalField ... fields) {
        Long[] values = new Long[fields.length];
        int i = 0;
        for (TemporalField field : fields) {
            values[i++] = this.getFieldValue0(field);
        }
        return values;
    }

    public List<Object> getCalendricalList() {
        return this.objects;
    }

    public DateTimeBuilder addCalendrical(Object object) {
        Objects.requireNonNull(object, "object");
        if (object instanceof DateTimeBuilder) {
            DateTimeBuilder dtb = (DateTimeBuilder)object;
            for (TemporalField field : dtb.getFieldValueMap().keySet()) {
                this.addFieldValue(field, dtb.getFieldValue(field));
            }
            return this;
        }
        if (object instanceof Instant) {
            this.addFieldValue(ChronoField.INSTANT_SECONDS, ((Instant)object).getEpochSecond());
            this.addFieldValue(ChronoField.NANO_OF_SECOND, ((Instant)object).getNano());
        } else {
            this.objects.add(object);
        }
        return this;
    }

    public DateTimeBuilder resolve() {
        this.splitObjects();
        if (this.otherFields != null) {
            block0: while (true) {
                HashSet<Map.Entry<TemporalField, Long>> entrySet = new HashSet<Map.Entry<TemporalField, Long>>(this.otherFields.entrySet());
                for (Map.Entry entry : entrySet) {
                    if (!((TemporalField)entry.getKey()).resolve(this, (Long)entry.getValue())) continue;
                    continue block0;
                }
                break;
            }
        }
        this.mergeDate();
        this.mergeTime();
        return this;
    }

    private void mergeDate() {
        if (this.standardFields.containsKey(ChronoField.EPOCH_DAY)) {
            this.checkDate(LocalDate.ofEpochDay(this.standardFields.remove(ChronoField.EPOCH_DAY)));
            return;
        }
        if (this.standardFields.containsKey(ChronoField.EPOCH_MONTH)) {
            long em = this.standardFields.remove(ChronoField.EPOCH_MONTH);
            this.addFieldValue(ChronoField.MONTH_OF_YEAR, em % 12L + 1L);
            this.addFieldValue(ChronoField.YEAR, em / 12L + 1970L);
        }
        if (this.standardFields.containsKey(ChronoField.YEAR)) {
            if (this.standardFields.containsKey(ChronoField.MONTH_OF_YEAR)) {
                if (this.standardFields.containsKey(ChronoField.DAY_OF_MONTH)) {
                    int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                    int moy = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.MONTH_OF_YEAR));
                    int dom = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.DAY_OF_MONTH));
                    this.checkDate(LocalDate.of(y, moy, dom));
                    return;
                }
                if (this.standardFields.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                    if (this.standardFields.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                        int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                        int moy = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.MONTH_OF_YEAR));
                        int aw = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                        int ad = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                        this.checkDate(LocalDate.of(y, moy, 1).plusDays((aw - 1) * 7 + (ad - 1)));
                        return;
                    }
                    if (this.standardFields.containsKey(ChronoField.DAY_OF_WEEK)) {
                        int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                        int moy = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.MONTH_OF_YEAR));
                        int aw = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                        int dow = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.DAY_OF_WEEK));
                        this.checkDate(LocalDate.of(y, moy, 1).plusDays((aw - 1) * 7).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(dow))));
                        return;
                    }
                }
            }
            if (this.standardFields.containsKey(ChronoField.DAY_OF_YEAR)) {
                int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                int doy = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.DAY_OF_YEAR));
                this.checkDate(LocalDate.ofYearDay(y, doy));
                return;
            }
            if (this.standardFields.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) {
                if (this.standardFields.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
                    int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                    int aw = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
                    int ad = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                    this.checkDate(LocalDate.of(y, 1, 1).plusDays((aw - 1) * 7 + (ad - 1)));
                    return;
                }
                if (this.standardFields.containsKey(ChronoField.DAY_OF_WEEK)) {
                    int y = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.YEAR));
                    int aw = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
                    int dow = Jdk8Methods.safeToInt(this.standardFields.remove(ChronoField.DAY_OF_WEEK));
                    this.checkDate(LocalDate.of(y, 1, 1).plusDays((aw - 1) * 7).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(dow))));
                    return;
                }
            }
        }
    }

    private void checkDate(LocalDate date) {
        this.addCalendrical(date);
        for (ChronoField field : this.standardFields.keySet()) {
            long val1;
            try {
                val1 = date.getLong(field);
            }
            catch (DateTimeException ex) {
                continue;
            }
            Long val2 = this.standardFields.get(field);
            if (val1 == val2) continue;
            throw new DateTimeException("Conflict found: Field " + field + " " + val1 + " differs from " + field + " " + val2 + " derived from " + date);
        }
    }

    private void mergeTime() {
        long ch;
        if (this.standardFields.containsKey(ChronoField.CLOCK_HOUR_OF_DAY)) {
            ch = this.standardFields.remove(ChronoField.CLOCK_HOUR_OF_DAY);
            this.addFieldValue(ChronoField.HOUR_OF_DAY, ch == 24L ? 0L : ch);
        }
        if (this.standardFields.containsKey(ChronoField.CLOCK_HOUR_OF_AMPM)) {
            ch = this.standardFields.remove(ChronoField.CLOCK_HOUR_OF_AMPM);
            this.addFieldValue(ChronoField.HOUR_OF_AMPM, ch == 12L ? 0L : ch);
        }
        if (this.standardFields.containsKey(ChronoField.AMPM_OF_DAY) && this.standardFields.containsKey(ChronoField.HOUR_OF_AMPM)) {
            long ap = this.standardFields.remove(ChronoField.AMPM_OF_DAY);
            long hap = this.standardFields.remove(ChronoField.HOUR_OF_AMPM);
            this.addFieldValue(ChronoField.HOUR_OF_DAY, ap * 12L + hap);
        }
        if (this.standardFields.containsKey(ChronoField.NANO_OF_DAY)) {
            long nod = this.standardFields.remove(ChronoField.NANO_OF_DAY);
            this.addFieldValue(ChronoField.SECOND_OF_DAY, nod / 1000000000L);
            this.addFieldValue(ChronoField.NANO_OF_SECOND, nod % 1000000000L);
        }
        if (this.standardFields.containsKey(ChronoField.MICRO_OF_DAY)) {
            long cod = this.standardFields.remove(ChronoField.MICRO_OF_DAY);
            this.addFieldValue(ChronoField.SECOND_OF_DAY, cod / 1000000L);
            this.addFieldValue(ChronoField.MICRO_OF_SECOND, cod % 1000000L);
        }
        if (this.standardFields.containsKey(ChronoField.MILLI_OF_DAY)) {
            long lod = this.standardFields.remove(ChronoField.MILLI_OF_DAY);
            this.addFieldValue(ChronoField.SECOND_OF_DAY, lod / 1000L);
            this.addFieldValue(ChronoField.MILLI_OF_SECOND, lod % 1000L);
        }
        if (this.standardFields.containsKey(ChronoField.SECOND_OF_DAY)) {
            long sod = this.standardFields.remove(ChronoField.SECOND_OF_DAY);
            this.addFieldValue(ChronoField.HOUR_OF_DAY, sod / 3600L);
            this.addFieldValue(ChronoField.MINUTE_OF_HOUR, sod / 60L % 60L);
            this.addFieldValue(ChronoField.SECOND_OF_MINUTE, sod % 60L);
        }
        if (this.standardFields.containsKey(ChronoField.MINUTE_OF_DAY)) {
            long mod = this.standardFields.remove(ChronoField.MINUTE_OF_DAY);
            this.addFieldValue(ChronoField.HOUR_OF_DAY, mod / 60L);
            this.addFieldValue(ChronoField.MINUTE_OF_HOUR, mod % 60L);
        }
        if (this.standardFields.containsKey(ChronoField.MILLI_OF_SECOND) && this.standardFields.containsKey(ChronoField.MICRO_OF_SECOND)) {
            long los = this.standardFields.remove(ChronoField.MILLI_OF_SECOND);
            long cos = this.standardFields.get(ChronoField.MICRO_OF_SECOND);
            this.addFieldValue(ChronoField.MICRO_OF_SECOND, los * 1000L + cos % 1000L);
        }
        Long hod = this.standardFields.get(ChronoField.HOUR_OF_DAY);
        Long moh = this.standardFields.get(ChronoField.MINUTE_OF_HOUR);
        Long som = this.standardFields.get(ChronoField.SECOND_OF_MINUTE);
        Long nos = this.standardFields.get(ChronoField.NANO_OF_SECOND);
        if (hod != null) {
            int hodVal = Jdk8Methods.safeToInt(hod);
            if (moh != null) {
                int mohVal = Jdk8Methods.safeToInt(moh);
                if (som != null) {
                    int somVal = Jdk8Methods.safeToInt(som);
                    if (nos != null) {
                        int nosVal = Jdk8Methods.safeToInt(nos);
                        this.addCalendrical(LocalTime.of(hodVal, mohVal, somVal, nosVal));
                    } else {
                        this.addCalendrical(LocalTime.of(hodVal, mohVal, somVal));
                    }
                } else {
                    this.addCalendrical(LocalTime.of(hodVal, mohVal));
                }
            } else {
                this.addCalendrical(LocalTime.of(hodVal, 0));
            }
        }
    }

    private void splitObjects() {
        ArrayList<Object> objectsToAdd = new ArrayList<Object>();
        for (Object object : this.objects) {
            if (object instanceof LocalDate || object instanceof LocalTime || object instanceof ZoneId || object instanceof Chrono) continue;
            if (object instanceof ZoneOffset || object instanceof Instant) {
                objectsToAdd.add(object);
                continue;
            }
            if (!(object instanceof TemporalAccessor)) continue;
        }
        for (Object object : objectsToAdd) {
            if (object == null) continue;
            this.addCalendrical(object);
        }
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.zoneId()) {
            Object zone = this.extract(ZoneId.class);
            if (zone == null && (zone = this.extract(ZoneOffset.class)) == null && this.standardFields.containsKey(ChronoField.OFFSET_SECONDS)) {
                zone = ZoneOffset.from(this);
            }
            return zone;
        }
        if (query == TemporalQueries.chrono()) {
            return this.extract(Chrono.class);
        }
        return super.query(query);
    }

    public <R> R extract(Class<?> type) {
        Object result = null;
        for (Object obj : this.objects) {
            if (!type.isInstance(obj)) continue;
            if (result != null && !result.equals(obj)) {
                throw new DateTimeException("Conflict found: " + type.getSimpleName() + " differs " + result + " vs " + obj + ": " + this);
            }
            result = obj;
        }
        return (R)result;
    }

    public <R> R build(Class<R> type) {
        return DateTimeBuilder.invokeFrom(type, this);
    }

    private static <R> R invokeFrom(Class<R> type, TemporalAccessor temporal) {
        try {
            Method m = type.getDeclaredMethod("from", TemporalAccessor.class);
            return type.cast(m.invoke(null, temporal));
        }
        catch (ReflectiveOperationException ex) {
            if (!(ex.getCause() instanceof DateTimeException)) {
                throw new DateTimeException("Unable to invoke method from(DateTime)", ex);
            }
            throw (DateTimeException)ex.getCause();
        }
    }

    public DateTimeBuilder clone() {
        DateTimeBuilder dtb = new DateTimeBuilder();
        dtb.objects.addAll(this.objects);
        dtb.standardFields.putAll(this.standardFields);
        dtb.standardFields.putAll(this.standardFields);
        if (this.otherFields != null) {
            dtb.otherFields.putAll(this.otherFields);
        }
        return dtb;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DateTimeBuilder[");
        Map<TemporalField, Long> fields = this.getFieldValueMap();
        if (fields.size() > 0) {
            buf.append("fields=").append(fields);
        }
        if (this.objects.size() > 0) {
            if (fields.size() > 0) {
                buf.append(", ");
            }
            buf.append("objects=").append(this.objects);
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field != null && this.containsFieldValue(field);
    }

    @Override
    public long getLong(TemporalField field) {
        return this.getFieldValue(field);
    }
}

