/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.calendar.JapaneseDate;
import org.threeten.bp.calendar.JapaneseEra;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.ISOChrono;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.LocalGregorianCalendar;

public final class JapaneseChrono
extends Chrono<JapaneseChrono>
implements Serializable {
    static final LocalGregorianCalendar JCAL = (LocalGregorianCalendar)CalendarSystem.forName("japanese");
    static final Locale LOCALE = Locale.forLanguageTag("ja-JP-u-ca-japanese");
    public static final JapaneseChrono INSTANCE = new JapaneseChrono();
    public static final Era<JapaneseChrono> ERA_SEIREKI = JapaneseEra.SEIREKI;
    public static final Era<JapaneseChrono> ERA_MEIJI = JapaneseEra.MEIJI;
    public static final Era<JapaneseChrono> ERA_TAISHO = JapaneseEra.TAISHO;
    public static final Era<JapaneseChrono> ERA_SHOWA = JapaneseEra.SHOWA;
    public static final Era<JapaneseChrono> ERA_HEISEI = JapaneseEra.HEISEI;
    private static final long serialVersionUID = 459996390165777884L;
    private static final Map<String, String[]> ERA_NARROW_NAMES = new HashMap<String, String[]>();
    private static final Map<String, String[]> ERA_SHORT_NAMES = new HashMap<String, String[]>();
    private static final Map<String, String[]> ERA_FULL_NAMES = new HashMap<String, String[]>();
    private static final String FALLBACK_LANGUAGE = "en";
    private static final String TARGET_LANGUAGE = "ja";

    private JapaneseChrono() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Japanese";
    }

    @Override
    public String getCalendarType() {
        return "japanese";
    }

    @Override
    public ChronoLocalDate<JapaneseChrono> date(Era<JapaneseChrono> era, int yearOfEra, int month, int dayOfMonth) {
        if (!(era instanceof JapaneseEra)) {
            throw new DateTimeException("Era must be JapaneseEra");
        }
        return JapaneseDate.of((JapaneseEra)era, yearOfEra, month, dayOfMonth);
    }

    @Override
    public ChronoLocalDate<JapaneseChrono> date(int prolepticYear, int month, int dayOfMonth) {
        return new JapaneseDate(LocalDate.of(prolepticYear, month, dayOfMonth));
    }

    @Override
    public ChronoLocalDate<JapaneseChrono> dateYearDay(int prolepticYear, int dayOfYear) {
        LocalDate date = LocalDate.ofYearDay(prolepticYear, dayOfYear);
        return this.date(prolepticYear, date.getMonthValue(), date.getDayOfMonth());
    }

    @Override
    public ChronoLocalDate<JapaneseChrono> date(TemporalAccessor temporal) {
        if (temporal instanceof JapaneseDate) {
            return (JapaneseDate)temporal;
        }
        return new JapaneseDate(LocalDate.from(temporal));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return ISOChrono.INSTANCE.isLeapYear(prolepticYear);
    }

    @Override
    public int prolepticYear(Era<JapaneseChrono> era, int yearOfEra) {
        if (!(era instanceof JapaneseEra)) {
            throw new DateTimeException("Era must be JapaneseEra");
        }
        JapaneseEra jera = (JapaneseEra)era;
        int gregorianYear = jera.getPrivateEra().getSinceDate().getYear() + yearOfEra - 1;
        if (yearOfEra == 1) {
            return gregorianYear;
        }
        LocalGregorianCalendar.Date jdate = JCAL.newCalendarDate(null);
        jdate.setEra(jera.getPrivateEra()).setDate(yearOfEra, 1, 1);
        JCAL.normalize(jdate);
        if (jdate.getNormalizedYear() == gregorianYear) {
            return gregorianYear;
        }
        throw new DateTimeException("invalid yearOfEra value");
    }

    @Override
    public Era<JapaneseChrono> eraOf(int eraValue) {
        return JapaneseEra.of(eraValue);
    }

    @Override
    public List<Era<JapaneseChrono>> eras() {
        return Arrays.asList(JapaneseEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        int fieldIndex;
        switch (field) {
            case DAY_OF_MONTH: 
            case DAY_OF_WEEK: 
            case MICRO_OF_DAY: 
            case MICRO_OF_SECOND: 
            case HOUR_OF_DAY: 
            case HOUR_OF_AMPM: 
            case MINUTE_OF_DAY: 
            case MINUTE_OF_HOUR: 
            case SECOND_OF_DAY: 
            case SECOND_OF_MINUTE: 
            case MILLI_OF_DAY: 
            case MILLI_OF_SECOND: 
            case NANO_OF_DAY: 
            case NANO_OF_SECOND: 
            case CLOCK_HOUR_OF_DAY: 
            case CLOCK_HOUR_OF_AMPM: 
            case EPOCH_DAY: 
            case EPOCH_MONTH: {
                return field.range();
            }
        }
        Calendar jcal = Calendar.getInstance(LOCALE);
        switch (field) {
            case ERA: {
                return ValueRange.of(jcal.getMinimum(0) - 2, jcal.getMaximum(0) - 2);
            }
            case YEAR: 
            case YEAR_OF_ERA: {
                return ValueRange.of(-999999999L, jcal.getGreatestMinimum(1), jcal.getLeastMaximum(1), 999999999L);
            }
            case MONTH_OF_YEAR: {
                return ValueRange.of(jcal.getMinimum(2) + 1, jcal.getGreatestMinimum(2) + 1, jcal.getLeastMaximum(2) + 1, jcal.getMaximum(2) + 1);
            }
            case DAY_OF_YEAR: {
                fieldIndex = 6;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplementable field: " + field);
            }
        }
        return ValueRange.of(jcal.getMinimum(fieldIndex), jcal.getGreatestMinimum(fieldIndex), jcal.getLeastMaximum(fieldIndex), jcal.getMaximum(fieldIndex));
    }

    static {
        ERA_NARROW_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_NARROW_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_SHORT_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_SHORT_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "\u6176", "\u660e", "\u5927", "\u662d", "\u5e73"});
        ERA_FULL_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "Keio", "Meiji", "Taisho", "Showa", "Heisei"});
        ERA_FULL_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "\u6176\u5fdc", "\u660e\u6cbb", "\u5927\u6b63", "\u662d\u548c", "\u5e73\u6210"});
    }
}

