/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.util.Locale;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.ISOChrono;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.ValueRange;

enum ISOEra implements Era<ISOChrono>
{
    BCE,
    CE;


    public static ISOEra of(int era) {
        switch (era) {
            case 0: {
                return BCE;
            }
            case 1: {
                return CE;
            }
        }
        throw new DateTimeException("Invalid era: " + era);
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public ISOChrono getChrono() {
        return ISOChrono.INSTANCE;
    }

    @Override
    public ChronoLocalDate<ISOChrono> date(int year, int month, int day) {
        return this.getChrono().date((Era)this, year, month, day);
    }

    @Override
    public ChronoLocalDate<ISOChrono> dateYearDay(int year, int dayOfYear) {
        return this.getChrono().dateYearDay((Era)this, year, dayOfYear);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.ERA;
        }
        return field != null && field.doIsSupported(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.doRange(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.doGet(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.ERA, this.getValue());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.CHRONO) {
            return (R)this.getChrono();
        }
        return query.queryFrom(this);
    }

    @Override
    public String getText(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, style).toFormatter(locale).print(this);
    }
}

