/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import org.threeten.extra.chrono.AbstractDate;
import org.threeten.extra.chrono.PaxChronology;
import org.threeten.extra.chrono.PaxEra;

public final class PaxDate
extends AbstractDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -2229133057743750072L;
    private static final int PAX_0001_TO_ISO_1970 = 719163;
    private static final int DAYS_PER_LONG_CYCLE = 146097;
    private static final int DAYS_PER_CYCLE = 36526;
    private static final int DAYS_PER_SIX_CYCLE = 2191;
    private static final int YEARS_IN_DECADE = 10;
    private static final int YEARS_IN_CENTURY = 100;
    private static final int YEARS_IN_MILLENNIUM = 1000;
    private final int prolepticYear;
    private final short month;
    private final short day;

    public static PaxDate now() {
        return PaxDate.now(Clock.systemDefaultZone());
    }

    public static PaxDate now(ZoneId zone) {
        return PaxDate.now(Clock.system(zone));
    }

    public static PaxDate now(Clock clock) {
        LocalDate now = LocalDate.now(clock);
        return PaxDate.ofEpochDay(now.toEpochDay());
    }

    public static PaxDate of(int prolepticYear, int month, int dayOfMonth) {
        ChronoField.YEAR.checkValidValue(prolepticYear);
        PaxChronology.MONTH_OF_YEAR_RANGE.checkValidValue(month, ChronoField.MONTH_OF_YEAR);
        PaxChronology.DAY_OF_MONTH_RANGE.checkValidValue(dayOfMonth, ChronoField.DAY_OF_MONTH);
        if (month == 14 && !PaxChronology.INSTANCE.isLeapYear(prolepticYear)) {
            throw new DateTimeException("Invalid month 14 as " + prolepticYear + "is not a leap year");
        }
        if (dayOfMonth > 7 && month == 13 && PaxChronology.INSTANCE.isLeapYear(prolepticYear)) {
            throw new DateTimeException("Invalid date during Pax as " + prolepticYear + " is a leap year");
        }
        return new PaxDate(prolepticYear, month, dayOfMonth);
    }

    public static PaxDate from(TemporalAccessor temporal) {
        if (temporal instanceof PaxDate) {
            return (PaxDate)temporal;
        }
        return PaxDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    static PaxDate ofYearDay(int prolepticYear, int dayOfYear) {
        ChronoField.YEAR.checkValidValue(prolepticYear);
        PaxChronology.DAY_OF_YEAR_RANGE.checkValidValue(dayOfYear, ChronoField.DAY_OF_YEAR);
        boolean leap = PaxChronology.INSTANCE.isLeapYear(prolepticYear);
        if (dayOfYear > 364 && !leap) {
            throw new DateTimeException("Invalid date 'DayOfYear " + dayOfYear + "' as '" + prolepticYear + "' is not a leap year");
        }
        int month = (dayOfYear - 1) / 28 + 1;
        if (leap && month == 13 && dayOfYear >= 344) {
            ++month;
        }
        int dayOfMonth = dayOfYear - (month - 1) * 28;
        if (month == 14) {
            dayOfMonth += 21;
        }
        return PaxDate.of(prolepticYear, month, dayOfMonth);
    }

    static PaxDate ofEpochDay(long epochDay) {
        ChronoField.EPOCH_DAY.range().checkValidValue(epochDay, ChronoField.EPOCH_DAY);
        long paxEpochDay = epochDay + 719163L;
        int longCycle = (int)Math.floorDiv(paxEpochDay, 146097);
        int cycle = (int)(paxEpochDay - (long)(longCycle * 146097)) / 36526;
        int dayOfCycle = Math.floorMod(paxEpochDay - (long)(longCycle * 146097), 36526);
        if (dayOfCycle >= 36155) {
            int dayOfYear = dayOfCycle - 36155 + 1;
            return PaxDate.ofYearDay(longCycle * 400 + cycle * 100 + 100, dayOfYear);
        }
        if (paxEpochDay >= 0L) {
            if (dayOfCycle >= 35784) {
                int dayOfYear = dayOfCycle - 35784 + 1;
                return PaxDate.ofYearDay(longCycle * 400 + cycle * 100 + 99, dayOfYear);
            }
            int sixCycle = dayOfCycle / 2191;
            int dayOfSixCycle = dayOfCycle % 2191;
            int year = dayOfSixCycle / 364 + 1;
            int dayOfYear = dayOfSixCycle % 364 + 1;
            if (year == 7) {
                --year;
                dayOfYear += 364;
            }
            return PaxDate.ofYearDay(longCycle * 400 + cycle * 100 + sixCycle * 6 + year, dayOfYear);
        }
        if (dayOfCycle < 371) {
            return PaxDate.ofYearDay(longCycle * 400 + cycle * 100 + 1, dayOfCycle + 1);
        }
        int offsetCycle = dayOfCycle + 728 - 7;
        int sixCycle = offsetCycle / 2191;
        int dayOfSixCycle = offsetCycle % 2191;
        int year = dayOfSixCycle / 364 + 1;
        int dayOfYear = dayOfSixCycle % 364 + 1;
        if (year == 7) {
            --year;
            dayOfYear += 364;
        }
        return PaxDate.ofYearDay(longCycle * 400 + cycle * 100 - 2 + (sixCycle * 6 + year), dayOfYear);
    }

    private static PaxDate resolvePreviousValid(int prolepticYear, int month, int day) {
        int monthR = Math.min(month, 13 + (PaxChronology.INSTANCE.isLeapYear(prolepticYear) ? 1 : 0));
        int dayR = Math.min(day, month == 13 && PaxChronology.INSTANCE.isLeapYear(prolepticYear) ? 7 : 28);
        return PaxDate.of(prolepticYear, monthR, dayR);
    }

    private static long getLeapMonthsBefore(long prolepticMonth) {
        long offsetMonth = prolepticMonth - (long)(prolepticMonth <= 0L ? 13 : 12);
        return 18L * Math.floorDiv(offsetMonth, 1318) - Math.floorDiv(offsetMonth, 5272) + (long)((Math.floorMod(offsetMonth, 1318) - (offsetMonth <= 0L ? 1317 : 0)) / 1304 + (offsetMonth <= 0L ? 1 : 0)) + (long)((Math.floorMod(offsetMonth, 1318) + (offsetMonth <= 0L ? 25 : 0)) / 79);
    }

    private static long getLeapYearsBefore(long prolepticYear) {
        return 18L * Math.floorDiv(prolepticYear - 1L, 100) - Math.floorDiv(prolepticYear - 1L, 400) + (long)((Math.floorMod(prolepticYear - 1L, 100) - (prolepticYear <= 0L ? 99 : 0)) / 99) + (long)(prolepticYear <= 0L ? 1 : 0) + (long)((Math.floorMod(prolepticYear - 1L, 100) + (prolepticYear <= 0L ? 2 : 0)) / 6);
    }

    private PaxDate(int prolepticYear, int month, int dayOfMonth) {
        this.prolepticYear = prolepticYear;
        this.month = (short)month;
        this.day = (short)dayOfMonth;
    }

    private Object readResolve() {
        return PaxDate.of(this.prolepticYear, this.month, this.day);
    }

    @Override
    int getProlepticYear() {
        return this.prolepticYear;
    }

    @Override
    int getMonth() {
        return this.month;
    }

    @Override
    int getDayOfMonth() {
        return this.day;
    }

    @Override
    int getDayOfYear() {
        return (this.month - 1) * 28 - (this.month == 14 ? 21 : 0) + this.getDayOfMonth();
    }

    @Override
    int lengthOfYearInMonths() {
        return 13 + (this.isLeapYear() ? 1 : 0);
    }

    @Override
    ValueRange rangeAlignedWeekOfMonth() {
        return ValueRange.of(1L, this.month == 13 && this.isLeapYear() ? 1L : 4L);
    }

    @Override
    PaxDate resolvePrevious(int newYear, int newMonth, int dayOfMonth) {
        return PaxDate.resolvePreviousValid(newYear, newMonth, dayOfMonth);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ALIGNED_WEEK_OF_YEAR) {
            return ValueRange.of(1L, 52 + (this.isLeapYear() ? 1 : 0));
        }
        if (field == ChronoField.MONTH_OF_YEAR) {
            return ValueRange.of(1L, 13 + (this.isLeapYear() ? 1 : 0));
        }
        return super.range(field);
    }

    @Override
    long getProlepticMonth() {
        return (long)this.getProlepticYear() * 13L + PaxDate.getLeapYearsBefore(this.getProlepticYear()) + (long)this.month - 1L;
    }

    @Override
    public PaxChronology getChronology() {
        return PaxChronology.INSTANCE;
    }

    @Override
    public PaxEra getEra() {
        return this.prolepticYear >= 1 ? PaxEra.CE : PaxEra.BCE;
    }

    @Override
    public int lengthOfMonth() {
        switch (this.month) {
            case 13: {
                return this.isLeapYear() ? 7 : 28;
            }
        }
        return 28;
    }

    @Override
    public int lengthOfYear() {
        return 364 + (this.isLeapYear() ? 7 : 0);
    }

    @Override
    public PaxDate with(TemporalAdjuster adjuster) {
        return (PaxDate)adjuster.adjustInto(this);
    }

    @Override
    public PaxDate with(TemporalField field, long newValue) {
        if (field == ChronoField.YEAR) {
            return this.plusYears(Math.subtractExact(newValue, (long)this.getProlepticYear()));
        }
        return (PaxDate)super.with(field, newValue);
    }

    @Override
    public PaxDate plus(TemporalAmount amount) {
        return (PaxDate)amount.addTo(this);
    }

    @Override
    public PaxDate plus(long amountToAdd, TemporalUnit unit) {
        return (PaxDate)super.plus(amountToAdd, unit);
    }

    @Override
    PaxDate plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField.YEAR.checkValidIntValue((long)this.getProlepticYear() + yearsToAdd);
        if (this.month == 13 && !this.isLeapYear() && PaxChronology.INSTANCE.isLeapYear(newYear)) {
            return PaxDate.of(newYear, 14, this.getDayOfMonth());
        }
        return PaxDate.resolvePreviousValid(newYear, this.month, this.day);
    }

    @Override
    PaxDate plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long calcMonths = Math.addExact(this.getProlepticMonth(), monthsToAdd);
        long monthsRegularized = calcMonths - PaxDate.getLeapMonthsBefore(calcMonths);
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.floorDiv(monthsRegularized, 13));
        int newMonth = Math.toIntExact(calcMonths - ((long)newYear * 13L + PaxDate.getLeapYearsBefore(newYear)) + 1L);
        return PaxDate.resolvePreviousValid(newYear, newMonth, this.getDayOfMonth());
    }

    @Override
    public PaxDate minus(TemporalAmount amount) {
        return (PaxDate)amount.subtractFrom(this);
    }

    @Override
    public PaxDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<PaxDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return this.until(PaxDate.from(endExclusive), unit);
    }

    @Override
    long until(AbstractDate end, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            PaxDate paxEnd = PaxDate.from(end);
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.yearsUntil(paxEnd);
                }
                case DECADES: {
                    return this.yearsUntil(paxEnd) / 10L;
                }
                case CENTURIES: {
                    return this.yearsUntil(paxEnd) / 100L;
                }
                case MILLENNIA: {
                    return this.yearsUntil(paxEnd) / 1000L;
                }
            }
        }
        return super.until(end, unit);
    }

    long yearsUntil(PaxDate end) {
        long startYear = (long)this.getProlepticYear() * 512L + (long)this.getDayOfYear() + (long)(this.month == 13 && !this.isLeapYear() && end.isLeapYear() ? 7 : 0);
        long endYear = (long)end.getProlepticYear() * 512L + (long)end.getDayOfYear() + (long)(end.month == 13 && !end.isLeapYear() && this.isLeapYear() ? 7 : 0);
        return (endYear - startYear) / 512L;
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        PaxDate end = PaxDate.from(endDateExclusive);
        int years = Math.toIntExact(this.yearsUntil(end));
        PaxDate sameYearEnd = this.plusYears(years);
        int months = (int)sameYearEnd.monthsUntil(end);
        int days = (int)sameYearEnd.plusMonths(months).daysUntil(end);
        return this.getChronology().period(years, months, days);
    }

    @Override
    public long toEpochDay() {
        long paxEpochDay = ((long)this.getProlepticYear() - 1L) * 364L + PaxDate.getLeapYearsBefore(this.getProlepticYear()) * 7L + (long)this.getDayOfYear() - 1L;
        return paxEpochDay - 719163L;
    }
}

