/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.threeten.extra.chrono.AbstractDate;
import org.threeten.extra.chrono.BritishCutoverChronology;
import org.threeten.extra.chrono.JulianDate;
import org.threeten.extra.chrono.JulianEra;
import org.threeten.extra.chrono.Math;

public final class BritishCutoverDate
extends AbstractDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -9626278512674L;
    private final LocalDate isoDate;
    private final transient JulianDate julianDate;

    public static BritishCutoverDate now() {
        return BritishCutoverDate.now(Clock.systemDefaultZone());
    }

    public static BritishCutoverDate now(ZoneId zone) {
        return BritishCutoverDate.now(Clock.system(zone));
    }

    public static BritishCutoverDate now(Clock clock) {
        return new BritishCutoverDate(LocalDate.now(clock));
    }

    public static BritishCutoverDate of(int prolepticYear, int month, int dayOfMonth) {
        return BritishCutoverDate.create(prolepticYear, month, dayOfMonth);
    }

    public static BritishCutoverDate from(TemporalAccessor temporal) {
        if (temporal instanceof BritishCutoverDate) {
            return (BritishCutoverDate)temporal;
        }
        return new BritishCutoverDate(LocalDate.from(temporal));
    }

    static BritishCutoverDate ofYearDay(int prolepticYear, int dayOfYear) {
        if (prolepticYear < 1752 || prolepticYear == 1752 && dayOfYear <= 246) {
            JulianDate julian = JulianDate.ofYearDay(prolepticYear, dayOfYear);
            return new BritishCutoverDate(julian);
        }
        if (prolepticYear == 1752) {
            LocalDate iso = LocalDate.ofYearDay(prolepticYear, dayOfYear + 11);
            return new BritishCutoverDate(iso);
        }
        LocalDate iso = LocalDate.ofYearDay(prolepticYear, dayOfYear);
        return new BritishCutoverDate(iso);
    }

    static BritishCutoverDate ofEpochDay(long epochDay) {
        return new BritishCutoverDate(LocalDate.ofEpochDay(epochDay));
    }

    static BritishCutoverDate create(int prolepticYear, int month, int dayOfMonth) {
        if (prolepticYear < 1752) {
            JulianDate julian = JulianDate.of(prolepticYear, month, dayOfMonth);
            return new BritishCutoverDate(julian);
        }
        LocalDate iso = LocalDate.of(prolepticYear, month, dayOfMonth);
        if (iso.isBefore(BritishCutoverChronology.CUTOVER)) {
            JulianDate julian = JulianDate.of(prolepticYear, month, dayOfMonth);
            return new BritishCutoverDate(julian);
        }
        return new BritishCutoverDate(iso);
    }

    BritishCutoverDate(LocalDate isoDate) {
        Objects.requireNonNull(isoDate, "isoDate");
        this.isoDate = isoDate;
        this.julianDate = isoDate.isBefore(BritishCutoverChronology.CUTOVER) ? JulianDate.from(isoDate) : null;
    }

    BritishCutoverDate(JulianDate julianDate) {
        Objects.requireNonNull(julianDate, "julianDate");
        this.isoDate = LocalDate.from(julianDate);
        this.julianDate = this.isoDate.isBefore(BritishCutoverChronology.CUTOVER) ? julianDate : null;
    }

    private Object readResolve() {
        return new BritishCutoverDate(this.isoDate);
    }

    private boolean isCutoverYear() {
        return this.isoDate.getYear() == 1752 && this.isoDate.getDayOfYear() > 11;
    }

    private boolean isCutoverMonth() {
        return this.isoDate.getYear() == 1752 && this.isoDate.getMonthValue() == 9 && this.isoDate.getDayOfMonth() > 11;
    }

    @Override
    int getAlignedDayOfWeekInMonth() {
        if (this.isCutoverMonth() && this.julianDate == null) {
            return (this.getDayOfMonth() - 1 - 11) % this.lengthOfWeek() + 1;
        }
        return super.getAlignedDayOfWeekInMonth();
    }

    @Override
    int getAlignedWeekOfMonth() {
        if (this.isCutoverMonth() && this.julianDate == null) {
            return (this.getDayOfMonth() - 1 - 11) / this.lengthOfWeek() + 1;
        }
        return super.getAlignedWeekOfMonth();
    }

    @Override
    int getProlepticYear() {
        return this.julianDate != null ? this.julianDate.getProlepticYear() : this.isoDate.getYear();
    }

    @Override
    int getMonth() {
        return this.julianDate != null ? this.julianDate.getMonth() : this.isoDate.getMonthValue();
    }

    @Override
    int getDayOfMonth() {
        return this.julianDate != null ? this.julianDate.getDayOfMonth() : this.isoDate.getDayOfMonth();
    }

    @Override
    int getDayOfYear() {
        if (this.julianDate != null) {
            return this.julianDate.getDayOfYear();
        }
        if (this.isoDate.getYear() == 1752) {
            return this.isoDate.getDayOfYear() - 11;
        }
        return this.isoDate.getDayOfYear();
    }

    @Override
    public ValueRange rangeChrono(ChronoField field) {
        switch (field) {
            case DAY_OF_MONTH: {
                if (this.isCutoverMonth()) {
                    return ValueRange.of(1L, 30L);
                }
                return ValueRange.of(1L, this.lengthOfMonth());
            }
            case DAY_OF_YEAR: {
                return ValueRange.of(1L, this.lengthOfYear());
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return this.rangeAlignedWeekOfMonth();
            }
            case ALIGNED_WEEK_OF_YEAR: {
                if (this.isCutoverYear()) {
                    return ValueRange.of(1L, 51L);
                }
                return ChronoField.ALIGNED_WEEK_OF_YEAR.range();
            }
        }
        return this.getChronology().range(field);
    }

    @Override
    ValueRange rangeAlignedWeekOfMonth() {
        if (this.isCutoverMonth()) {
            return ValueRange.of(1L, 3L);
        }
        return ValueRange.of(1L, this.getMonth() == 2 && !this.isLeapYear() ? 4L : 5L);
    }

    @Override
    BritishCutoverDate resolvePrevious(int year, int month, int dayOfMonth) {
        switch (month) {
            case 2: {
                dayOfMonth = Math.min(dayOfMonth, this.getChronology().isLeapYear(year) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                dayOfMonth = Math.min(dayOfMonth, 30);
                break;
            }
        }
        return BritishCutoverDate.create(year, month, dayOfMonth);
    }

    @Override
    public BritishCutoverChronology getChronology() {
        return BritishCutoverChronology.INSTANCE;
    }

    @Override
    public JulianEra getEra() {
        return this.getProlepticYear() >= 1 ? JulianEra.AD : JulianEra.BC;
    }

    @Override
    public int lengthOfMonth() {
        if (this.isCutoverMonth()) {
            return 19;
        }
        return this.julianDate != null ? this.julianDate.lengthOfMonth() : this.isoDate.lengthOfMonth();
    }

    @Override
    public int lengthOfYear() {
        if (this.isCutoverYear()) {
            return 355;
        }
        return this.julianDate != null ? this.julianDate.lengthOfYear() : this.isoDate.lengthOfYear();
    }

    @Override
    public BritishCutoverDate with(TemporalAdjuster adjuster) {
        return (BritishCutoverDate)adjuster.adjustInto(this);
    }

    @Override
    public BritishCutoverDate with(TemporalField field, long newValue) {
        return (BritishCutoverDate)super.with(field, newValue);
    }

    @Override
    public BritishCutoverDate plus(TemporalAmount amount) {
        return (BritishCutoverDate)amount.addTo(this);
    }

    @Override
    public BritishCutoverDate plus(long amountToAdd, TemporalUnit unit) {
        return (BritishCutoverDate)super.plus(amountToAdd, unit);
    }

    @Override
    public BritishCutoverDate minus(TemporalAmount amount) {
        return (BritishCutoverDate)amount.subtractFrom(this);
    }

    @Override
    public BritishCutoverDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<BritishCutoverDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return super.until(BritishCutoverDate.from(endExclusive), unit);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        AbstractDate calcDate;
        BritishCutoverDate end = BritishCutoverDate.from(endDateExclusive);
        long totalMonths = end.getProlepticMonth() - this.getProlepticMonth();
        int days = end.getDayOfMonth() - this.getDayOfMonth();
        if (totalMonths == 0L && this.isCutoverMonth()) {
            if (this.julianDate != null && end.julianDate == null) {
                days -= 11;
            } else if (this.julianDate == null && end.julianDate != null) {
                days += 11;
            }
        } else if (totalMonths > 0L) {
            if (this.julianDate != null && end.julianDate == null) {
                calcDate = this.plusMonths(totalMonths);
                days = (int)(end.toEpochDay() - calcDate.toEpochDay());
            }
            if (days < 0) {
                calcDate = this.plusMonths(--totalMonths);
                days = (int)(end.toEpochDay() - calcDate.toEpochDay());
            }
        } else if (totalMonths < 0L && days > 0) {
            calcDate = this.plusMonths(++totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        }
        int years = Math.toIntExact(totalMonths / (long)this.lengthOfYearInMonths());
        int months = (int)(totalMonths % (long)this.lengthOfYearInMonths());
        return this.getChronology().period(years, months, days);
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.localDate()) {
            return (R)this.isoDate;
        }
        return super.query(query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BritishCutoverDate) {
            BritishCutoverDate otherDate = (BritishCutoverDate)obj;
            return this.isoDate.equals(otherDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }
}

