/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAdjuster;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.threeten.extra.Math;

public final class LocalDateRange
implements Serializable {
    public static final LocalDateRange ALL = new LocalDateRange(LocalDate.MIN, LocalDate.MAX);
    private static final long serialVersionUID = 3358656715467L;
    private final LocalDate start;
    private final LocalDate end;

    public static LocalDateRange of(LocalDate startInclusive, LocalDate endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        if (endExclusive.isBefore(startInclusive)) {
            throw new DateTimeException("End date must on or after start date");
        }
        return new LocalDateRange(startInclusive, endExclusive);
    }

    public static LocalDateRange ofClosed(LocalDate startInclusive, LocalDate endInclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endInclusive, "endInclusive");
        if (endInclusive.isBefore(startInclusive)) {
            throw new DateTimeException("Start date must on or before end date");
        }
        LocalDate end = endInclusive.equals(LocalDate.MAX) ? LocalDate.MAX : endInclusive.plusDays(1L);
        return new LocalDateRange(startInclusive, end);
    }

    public static LocalDateRange of(LocalDate startInclusive, Period period) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(period, "period");
        if (period.isNegative()) {
            throw new DateTimeException("Period must not be zero or negative");
        }
        return new LocalDateRange(startInclusive, startInclusive.plus(period));
    }

    public static LocalDateRange parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        for (int i = 0; i < text.length(); ++i) {
            char c;
            if (text.charAt(i) != '/') continue;
            char firstChar = text.charAt(0);
            if (firstChar == 'P' || firstChar == 'p') {
                Period duration = Period.parse(text.subSequence(0, i));
                LocalDate end = LocalDate.parse(text.subSequence(i + 1, text.length()));
                return LocalDateRange.of(end.minus(duration), end);
            }
            LocalDate start = LocalDate.parse(text.subSequence(0, i));
            if (i + 1 < text.length() && ((c = text.charAt(i + 1)) == 'P' || c == 'p')) {
                Period duration = Period.parse(text.subSequence(i + 1, text.length()));
                return LocalDateRange.of(start, start.plus(duration));
            }
            LocalDate end = LocalDate.parse(text.subSequence(i + 1, text.length()));
            return LocalDateRange.of(start, end);
        }
        throw new DateTimeParseException("LocalDateRange cannot be parsed, no forward slash found", text, 0);
    }

    private LocalDateRange(LocalDate startInclusive, LocalDate endExclusive) {
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public LocalDate getEndInclusive() {
        if (this.isUnboundedEnd()) {
            return LocalDate.MAX;
        }
        if (this.end.equals(LocalDate.MIN)) {
            return LocalDate.MIN;
        }
        return this.end.minusDays(1L);
    }

    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean isUnboundedStart() {
        return this.start.equals(LocalDate.MIN);
    }

    public boolean isUnboundedEnd() {
        return this.end.equals(LocalDate.MAX);
    }

    public LocalDateRange withStart(TemporalAdjuster adjuster) {
        return LocalDateRange.of(this.start.with(adjuster), this.end);
    }

    public LocalDateRange withEnd(TemporalAdjuster adjuster) {
        return LocalDateRange.of(this.start, this.end.with(adjuster));
    }

    public boolean contains(LocalDate date) {
        Objects.requireNonNull(date, "date");
        return this.start.compareTo(date) <= 0 && (date.compareTo(this.end) < 0 || this.isUnboundedEnd());
    }

    public boolean encloses(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.start.compareTo(other.start) <= 0 && other.end.compareTo(this.end) <= 0;
    }

    public boolean abuts(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.end.equals(other.start) ^ this.start.equals(other.end);
    }

    public boolean isConnected(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.equals(other) || this.start.compareTo(other.end) <= 0 && other.start.compareTo(this.end) <= 0;
    }

    public boolean overlaps(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return other.equals(this) || this.start.compareTo(other.end) < 0 && other.start.compareTo(this.end) < 0;
    }

    public LocalDateRange intersection(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Ranges do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return this;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return other;
        }
        LocalDate newStart = cmpStart >= 0 ? this.start : other.start;
        LocalDate newEnd = cmpEnd <= 0 ? this.end : other.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public LocalDateRange union(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Ranges do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return other;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return this;
        }
        LocalDate newStart = cmpStart >= 0 ? other.start : this.start;
        LocalDate newEnd = cmpEnd <= 0 ? other.end : this.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public LocalDateRange span(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        LocalDate newStart = cmpStart >= 0 ? other.start : this.start;
        LocalDate newEnd = cmpEnd <= 0 ? other.end : this.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public Stream<LocalDate> stream() {
        Iterator<LocalDate> it = new Iterator<LocalDate>(){
            private LocalDate current;
            {
                this.current = LocalDateRange.this.start;
            }

            @Override
            public LocalDate next() {
                LocalDate result = this.current;
                this.current = this.current.plusDays(1L);
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.current.isBefore(LocalDateRange.this.end);
            }
        };
        long count = this.end.toEpochDay() - this.start.toEpochDay() + 1L;
        Spliterator<LocalDate> spliterator = Spliterators.spliterator(it, count, 17749);
        return StreamSupport.stream(spliterator, false);
    }

    public boolean isAfter(LocalDate date) {
        return this.start.compareTo(date) > 0;
    }

    public boolean isBefore(LocalDate date) {
        return this.end.compareTo(date) <= 0 && this.start.compareTo(date) < 0;
    }

    public boolean isAfter(LocalDateRange other) {
        return this.start.compareTo(other.end) >= 0 && !other.equals(this);
    }

    public boolean isBefore(LocalDateRange range) {
        return this.end.compareTo(range.start) <= 0 && !range.equals(this);
    }

    public int lengthInDays() {
        return Math.toIntExact(this.end.toEpochDay() - this.start.toEpochDay());
    }

    public Period toPeriod() {
        return Period.between(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalDateRange) {
            LocalDateRange other = (LocalDateRange)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + '/' + this.end.toString();
    }
}

