/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class DayOfMonth
implements TemporalAccessor,
TemporalAdjuster,
Comparable<DayOfMonth>,
Serializable {
    private static final long serialVersionUID = -8840172642009917873L;
    private static final DayOfMonth[] VALUES = new DayOfMonth[31];
    private final int day;

    public static Year now() {
        return DayOfMonth.now(Clock.systemDefaultZone());
    }

    public static Year now(ZoneId zone) {
        return DayOfMonth.now(Clock.system(zone));
    }

    public static Year now(Clock clock) {
        LocalDate now = LocalDate.now(clock);
        return Year.of(now.getYear());
    }

    public static DayOfMonth of(int dayOfMonth) {
        try {
            return VALUES[dayOfMonth - 1];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new DateTimeException("Invalid value for DayOfMonth: " + dayOfMonth);
        }
    }

    public static DayOfMonth from(TemporalAccessor temporal) {
        if (temporal instanceof DayOfMonth) {
            return (DayOfMonth)temporal;
        }
        Objects.requireNonNull(temporal, "temporal");
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDate.from(temporal);
            }
            return DayOfMonth.of(temporal.get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain DayOfMonth from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    private DayOfMonth(int dayOfMonth) {
        this.day = dayOfMonth;
    }

    private Object readResolve() {
        return DayOfMonth.of(this.day);
    }

    public int getValue() {
        return this.day;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.DAY_OF_MONTH;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        return TemporalAccessor.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return TemporalAccessor.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.DAY_OF_MONTH) {
            return this.day;
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public boolean isValidYearMonth(YearMonth yearMonth) {
        return yearMonth != null && yearMonth.isValidDay(this.day);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.DAY_OF_MONTH, this.day);
    }

    public MonthDay atMonth(Month month) {
        return MonthDay.of(month, Math.min(this.day, month.maxLength()));
    }

    public MonthDay atMonth(int month) {
        return this.atMonth(Month.of(month));
    }

    public LocalDate atYearMonth(YearMonth yearMonth) {
        return yearMonth.atDay(Math.min(this.day, yearMonth.lengthOfMonth()));
    }

    @Override
    public int compareTo(DayOfMonth other) {
        return this.day - other.day;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DayOfMonth) {
            return this.day == ((DayOfMonth)obj).day;
        }
        return false;
    }

    public int hashCode() {
        return this.day;
    }

    public String toString() {
        return "DayOfMonth:" + this.day;
    }

    static {
        for (int i = 0; i < 31; ++i) {
            DayOfMonth.VALUES[i] = new DayOfMonth(i + 1);
        }
    }
}

