/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6533504325942417606L;
    public static int DEFAULT_TIMEOUT_MS = Integer.MAX_VALUE;
    private XmlSuite m_suite;
    private String m_name;
    private Integer m_verbose = XmlSuite.DEFAULT_VERBOSE;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private int m_threadCount = -1;
    private List<XmlClass> m_xmlClasses = Lists.newArrayList();
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_parallel;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_timeOut;
    private Boolean m_skipFailedInvocationCounts = XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    private Map<String, List<Integer>> m_failedInvocationNumbers = null;
    private String m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private int m_index;
    private Boolean m_groupByInstances;

    public XmlTest(XmlSuite suite, int index) {
        this.init(suite, index);
    }

    public XmlTest(XmlSuite suite) {
        this.init(suite, 0);
    }

    private void init(XmlSuite suite, int index) {
        this.m_suite = suite;
        this.m_suite.getTests().add(this);
        this.m_index = index;
        this.m_name = "Command line test " + UUID.randomUUID().toString();
    }

    public XmlTest() {
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = Lists.newArrayList(packages);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getPackages();
    }

    public void setPackages(List<XmlPackage> p) {
        this.setXmlPackages(p);
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = Lists.newArrayList(methodSelectors);
    }

    public XmlSuite getSuite() {
        return this.m_suite;
    }

    public List<String> getIncludedGroups() {
        ArrayList<String> result = new ArrayList<String>(this.m_includedGroups);
        result.addAll(this.m_suite.getIncludedGroups());
        return result;
    }

    @Deprecated
    public void setClassNames(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public List<XmlClass> getXmlClasses() {
        return this.m_xmlClasses;
    }

    public List<XmlClass> getClasses() {
        return this.getXmlClasses();
    }

    public void setClasses(List<XmlClass> c) {
        this.setXmlClasses(c);
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVerbose(int v) {
        this.m_verbose = v;
    }

    public int getThreadCount() {
        return this.m_threadCount > 0 ? this.m_threadCount : this.getSuite().getThreadCount();
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public void setIncludedGroups(List<String> g) {
        this.m_includedGroups = g;
    }

    public void setExcludedGroups(List<String> g) {
        this.m_excludedGroups = g;
    }

    public List<String> getExcludedGroups() {
        ArrayList<String> result = new ArrayList<String>(this.m_excludedGroups);
        result.addAll(this.m_suite.getExcludedGroups());
        return result;
    }

    public void addIncludedGroup(String g) {
        this.m_includedGroups.add(g);
    }

    public void addExcludedGroup(String g) {
        this.m_excludedGroups.add(g);
    }

    public int getVerbose() {
        Integer result = this.m_verbose;
        if (null == result || XmlSuite.DEFAULT_VERBOSE.equals(this.m_verbose)) {
            result = this.m_suite.getVerbose();
        }
        if (null != result) {
            return result;
        }
        return 1;
    }

    public boolean getGroupByInstances() {
        Boolean result = this.m_groupByInstances;
        if (result == null || XmlSuite.DEFAULT_GROUP_BY_INSTANCES.equals(this.m_groupByInstances)) {
            result = this.m_suite.getGroupByInstances();
        }
        if (result != null) {
            return result;
        }
        return XmlSuite.DEFAULT_GROUP_BY_INSTANCES;
    }

    public void setGroupByInstances(boolean f) {
        this.m_groupByInstances = f;
    }

    public boolean isJUnit() {
        Boolean result = this.m_isJUnit;
        if (null == result || XmlSuite.DEFAULT_JUNIT.equals(result)) {
            result = this.m_suite.isJUnit();
        }
        return result;
    }

    public void setJUnit(boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setJunit(boolean isJUnit) {
        this.setJUnit(isJUnit);
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public boolean skipFailedInvocationCounts() {
        Boolean result = this.m_skipFailedInvocationCounts;
        if (null == result) {
            result = this.m_suite.skipFailedInvocationCounts();
        }
        return result;
    }

    public void addMetaGroup(String name, List<String> metaGroup) {
        this.m_metaGroups.put(name, metaGroup);
    }

    public void setMetaGroups(Map<String, List<String>> metaGroups) {
        this.m_metaGroups = metaGroups;
    }

    public Map<String, List<String>> getMetaGroups() {
        return this.m_metaGroups;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.put(key, value);
    }

    public String getParameter(String name) {
        String result = this.m_parameters.get(name);
        if (null == result) {
            result = this.m_suite.getParameter(name);
        }
        return result;
    }

    public Map<String, String> getParameters() {
        Map<String, String> result = Maps.newHashMap();
        Map<String, String> parameters = this.getSuite().getParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            result.put(parameter.getKey(), parameter.getValue());
        }
        for (String key : this.m_parameters.keySet()) {
            result.put(key, this.m_parameters.get(key));
        }
        return result;
    }

    public Map<String, String> getTestParameters() {
        return this.m_parameters;
    }

    public void setParallel(String parallel) {
        this.m_parallel = parallel;
    }

    public String getParallel() {
        String result = null;
        result = null != this.m_parallel || XmlSuite.DEFAULT_PARALLEL.equals(this.m_parallel) ? this.m_parallel : this.m_suite.getParallel();
        return result;
    }

    public String getTimeOut() {
        String result = null;
        result = null != this.m_timeOut ? this.m_timeOut : this.m_suite.getTimeOut();
        return result;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.getTimeOut() != null) {
            result = new Long(this.getTimeOut());
        }
        return result;
    }

    public void setTimeOut(long timeOut) {
        this.m_timeOut = Long.toString(timeOut);
    }

    public void setExpression(String expression) {
        this.setBeanShellExpression(expression);
    }

    public void setBeanShellExpression(String expression) {
        List<XmlMethodSelector> selectors = this.getMethodSelectors();
        if (selectors.size() > 0) {
            selectors.get(0).setExpression(expression);
        } else if (expression != null) {
            XmlMethodSelector xms = new XmlMethodSelector();
            xms.setExpression(expression);
            xms.setLanguage("BeanShell");
            this.getMethodSelectors().add(xms);
        }
    }

    public String getExpression() {
        List<XmlMethodSelector> selectors = this.getMethodSelectors();
        if (selectors.size() > 0) {
            return selectors.get(0).getExpression();
        }
        return null;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        if (this.m_isJUnit != null) {
            XmlUtils.setProperty(p, "junit", this.m_isJUnit.toString(), XmlSuite.DEFAULT_JUNIT.toString());
        }
        if (this.m_parallel != null) {
            XmlUtils.setProperty(p, "parallel", this.m_parallel, XmlSuite.DEFAULT_PARALLEL);
        }
        if (this.m_verbose != null) {
            XmlUtils.setProperty(p, "verbose", this.m_verbose.toString(), XmlSuite.DEFAULT_VERBOSE.toString());
        }
        if (null != this.m_timeOut) {
            p.setProperty("time-out", this.m_timeOut.toString());
        }
        if (this.m_preserveOrder != null) {
            p.setProperty("preserve-order", this.m_preserveOrder.toString());
        }
        if (this.m_threadCount != -1) {
            p.setProperty("thread-count", Integer.toString(this.m_threadCount));
        }
        xsb.push("test", p);
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(xmlMethodSelector.toXml(indent + "    "));
            }
            xsb.pop("method-selectors");
        }
        if (!this.m_parameters.isEmpty()) {
            for (Map.Entry entry : this.m_parameters.entrySet()) {
                Properties paramProps = new Properties();
                paramProps.setProperty("name", (String)entry.getKey());
                paramProps.setProperty("value", (String)entry.getValue());
                xsb.addEmptyElement("parameter", paramProps);
            }
        }
        if (!(this.m_metaGroups.isEmpty() && this.m_includedGroups.isEmpty() && this.m_excludedGroups.isEmpty())) {
            xsb.push("groups");
            for (String string : this.m_metaGroups.keySet()) {
                Properties metaGroupProp = new Properties();
                metaGroupProp.setProperty("name", string);
                xsb.push("define", metaGroupProp);
                for (String groupName : this.m_metaGroups.get(string)) {
                    Properties includeProps = new Properties();
                    includeProps.setProperty("name", groupName);
                    xsb.addEmptyElement("include", includeProps);
                }
                xsb.pop("define");
            }
            if (!this.m_includedGroups.isEmpty() || !this.m_excludedGroups.isEmpty()) {
                xsb.push("run");
                for (String string : this.m_includedGroups) {
                    Properties includeProps = new Properties();
                    includeProps.setProperty("name", string);
                    xsb.addEmptyElement("include", includeProps);
                }
                for (String string : this.m_excludedGroups) {
                    Properties excludeProps = new Properties();
                    excludeProps.setProperty("name", string);
                    xsb.addEmptyElement("exclude", excludeProps);
                }
                xsb.pop("run");
            }
            xsb.pop("groups");
        }
        if (null != this.m_xmlPackages && !this.m_xmlPackages.isEmpty()) {
            xsb.push("packages");
            for (XmlPackage xmlPackage : this.m_xmlPackages) {
                xsb.getStringBuffer().append(xmlPackage.toXml("      "));
            }
            xsb.pop("packages");
        }
        if (null != this.getXmlClasses() && !this.getXmlClasses().isEmpty()) {
            xsb.push("classes");
            for (XmlClass xmlClass : this.getXmlClasses()) {
                xsb.getStringBuffer().append(xmlClass.toXml(indent + "    "));
            }
            xsb.pop("classes");
        }
        xsb.pop("test");
        return xsb.toXML();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Test: \"" + this.m_name + "\"").append(" verbose:" + this.m_verbose);
        result.append("[parameters:");
        for (String k : this.m_parameters.keySet()) {
            String v = this.m_parameters.get(k);
            result.append(k + "=>" + v);
        }
        result.append("]");
        result.append("[metagroups:");
        for (String g : this.m_metaGroups.keySet()) {
            List<String> mg = this.m_metaGroups.get(g);
            result.append(g).append("=");
            for (String n : mg) {
                result.append(n).append(",");
            }
        }
        result.append("] ");
        result.append("[included: ");
        for (String g : this.m_includedGroups) {
            result.append(g).append(" ");
        }
        result.append("]");
        result.append("[excluded: ");
        for (String g : this.m_excludedGroups) {
            result.append(g).append("");
        }
        result.append("] ");
        result.append(" classes:");
        for (XmlClass cl : this.m_xmlClasses) {
            result.append(cl).append(" ");
        }
        result.append(" packages:");
        for (XmlPackage p : this.m_xmlPackages) {
            result.append(p).append(" ");
        }
        result.append("] ");
        return result.toString();
    }

    static void ppp(String s) {
        System.out.println("[XmlTest] " + s);
    }

    public Object clone() {
        XmlTest result = new XmlTest(this.getSuite());
        result.setName(this.getName());
        result.setIncludedGroups(this.getIncludedGroups());
        result.setExcludedGroups(this.getExcludedGroups());
        result.setJUnit(this.isJUnit());
        result.setParallel(this.getParallel());
        result.setVerbose(this.getVerbose());
        result.setParameters(this.getParameters());
        result.setXmlPackages(this.getXmlPackages());
        Map<String, List<String>> metagroups = this.getMetaGroups();
        for (Map.Entry<String, List<String>> group : metagroups.entrySet()) {
            result.addMetaGroup(group.getKey(), group.getValue());
        }
        return result;
    }

    public List<Integer> getInvocationNumbers(String method) {
        List<Integer> result;
        if (this.m_failedInvocationNumbers == null) {
            this.m_failedInvocationNumbers = Maps.newHashMap();
            for (XmlClass c : this.getXmlClasses()) {
                for (XmlInclude xi : c.getIncludedMethods()) {
                    List<Integer> invocationNumbers = xi.getInvocationNumbers();
                    if (invocationNumbers.size() <= 0) continue;
                    String methodName = c.getName() + "." + xi.getName();
                    this.m_failedInvocationNumbers.put(methodName, invocationNumbers);
                }
            }
        }
        if ((result = this.m_failedInvocationNumbers.get(method)) == null) {
            return Lists.newArrayList();
        }
        return result;
    }

    public void setPreserveOrder(String preserveOrder) {
        this.m_preserveOrder = preserveOrder;
    }

    public String getPreserveOrder() {
        String result = this.m_preserveOrder;
        if (result == null || XmlSuite.DEFAULT_PRESERVE_ORDER.equals(this.m_verbose)) {
            result = this.m_suite.getPreserveOrder();
        }
        return result;
    }

    public void setSuite(XmlSuite result) {
        this.m_suite = result;
    }

    public int getIndex() {
        return this.m_index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_excludedGroups == null ? 0 : ((Object)this.m_excludedGroups).hashCode());
        result = 31 * result + (this.m_failedInvocationNumbers == null ? 0 : ((Object)this.m_failedInvocationNumbers).hashCode());
        result = 31 * result + (this.m_includedGroups == null ? 0 : ((Object)this.m_includedGroups).hashCode());
        result = 31 * result + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        result = 31 * result + (this.m_metaGroups == null ? 0 : ((Object)this.m_metaGroups).hashCode());
        result = 31 * result + (this.m_methodSelectors == null ? 0 : ((Object)this.m_methodSelectors).hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        result = 31 * result + (this.m_parameters == null ? 0 : ((Object)this.m_parameters).hashCode());
        result = 31 * result + (this.m_preserveOrder == null ? 0 : this.m_preserveOrder.hashCode());
        result = 31 * result + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        result = 31 * result + this.m_threadCount;
        result = 31 * result + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        result = 31 * result + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        result = 31 * result + (this.m_xmlClasses == null ? 0 : ((Object)this.m_xmlClasses).hashCode());
        result = 31 * result + (this.m_xmlPackages == null ? 0 : ((Object)this.m_xmlPackages).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlTest other = (XmlTest)obj;
        if (this.m_excludedGroups == null ? other.m_excludedGroups != null : !((Object)this.m_excludedGroups).equals(other.m_excludedGroups)) {
            return XmlSuite.f();
        }
        if (this.m_failedInvocationNumbers == null ? other.m_failedInvocationNumbers != null : !((Object)this.m_failedInvocationNumbers).equals(other.m_failedInvocationNumbers)) {
            return XmlSuite.f();
        }
        if (this.m_includedGroups == null ? other.m_includedGroups != null : !((Object)this.m_includedGroups).equals(other.m_includedGroups)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? other.m_isJUnit != null && !other.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT) : !this.m_isJUnit.equals(other.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_metaGroups == null ? other.m_metaGroups != null : !((Object)this.m_metaGroups).equals(other.m_metaGroups)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? other.m_methodSelectors != null : !((Object)this.m_methodSelectors).equals(other.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? other.m_parallel != null : !this.m_parallel.equals(other.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_parameters == null ? other.m_parameters != null : !((Object)this.m_parameters).equals(other.m_parameters)) {
            return XmlSuite.f();
        }
        if (this.m_preserveOrder == null ? other.m_preserveOrder != null : !this.m_preserveOrder.equals(other.m_preserveOrder)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? other.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(other.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != other.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? other.m_timeOut != null : !this.m_timeOut.equals(other.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? other.m_verbose != null : !this.m_verbose.equals(other.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlClasses == null ? other.m_xmlClasses != null : !((Object)this.m_xmlClasses).equals(other.m_xmlClasses)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? other.m_xmlPackages != null : !((Object)this.m_xmlPackages).equals(other.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }
}

