/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.mock;

import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testifyproject.MockProvider;

public class MockitoMockProvider
implements MockProvider {
    public <T> T createFake(Class<? extends T> type) {
        return (T)Mockito.mock(type);
    }

    public <T> T createVirtual(Class<? extends T> type, T delegate) {
        return (T)Mockito.mock(type, (Answer)AdditionalAnswers.delegatesTo(delegate));
    }

    public <T> T createVirtualSut(Class<? extends T> type, T delegate) {
        return (T)Mockito.mock(type, (MockSettings)Mockito.withSettings().spiedInstance(delegate).defaultAnswer(Mockito.CALLS_REAL_METHODS));
    }

    public void verifyAllInteraction(Object ... collaborators) {
        Mockito.verifyNoMoreInteractions((Object[])collaborators);
    }

    public <T> Boolean isMock(T instance) {
        return Mockito.mockingDetails(instance).isMock();
    }
}

