/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.level.unit;

import java.util.Collection;
import org.testifyproject.ResourceController;
import org.testifyproject.ServiceInstance;
import org.testifyproject.ServiceProvider;
import org.testifyproject.TestConfigurer;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.TestRunner;
import org.testifyproject.annotation.Hint;
import org.testifyproject.core.DefaultServiceProvider;
import org.testifyproject.core.util.ServiceLocatorUtil;
import org.testifyproject.extension.CollaboratorReifier;
import org.testifyproject.extension.FinalReifier;
import org.testifyproject.extension.InitialReifier;
import org.testifyproject.extension.PostVerifier;
import org.testifyproject.extension.PreVerifier;
import org.testifyproject.extension.SutReifier;
import org.testifyproject.extension.Verifier;
import org.testifyproject.extension.annotation.UnitCategory;

@UnitCategory
public class UnitTestRunner
implements TestRunner {
    private final ServiceLocatorUtil serviceLocatorUtil;
    ResourceController resourceController;

    public UnitTestRunner() {
        this(ServiceLocatorUtil.INSTANCE);
    }

    UnitTestRunner(ServiceLocatorUtil serviceLocatorUtil) {
        this.serviceLocatorUtil = serviceLocatorUtil;
    }

    public void start(TestContext testContext) {
        Object testInstance = testContext.getTestInstance();
        TestConfigurer testConfigurer = testContext.getTestConfigurer();
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Collection guidelines = testDescriptor.getGuidelines();
        this.serviceLocatorUtil.findAllWithFilter(PreVerifier.class, guidelines, new Class[]{UnitCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
        this.resourceController = (ResourceController)this.serviceLocatorUtil.getOne(ResourceController.class);
        this.resourceController.start(testContext);
        ServiceProvider serviceProvider = (ServiceProvider)this.serviceLocatorUtil.getFromHintOrDefault(testContext, ServiceProvider.class, DefaultServiceProvider.class, Hint::serviceProvider);
        Object serviceContext = serviceProvider.create(testContext);
        testConfigurer.configure(testContext, serviceContext);
        ServiceInstance serviceInstance = serviceProvider.configure(testContext, serviceContext);
        testContext.addProperty("serviceInstance", (Object)serviceInstance);
        serviceProvider.postConfigure(testContext, serviceInstance);
        this.serviceLocatorUtil.findAllWithFilter(SutReifier.class, new Class[]{UnitCategory.class}).forEach(p -> p.reify(testContext));
        if (testDescriptor.getCollaboratorProvider().isPresent()) {
            this.serviceLocatorUtil.findAllWithFilter(InitialReifier.class, new Class[]{UnitCategory.class}).forEach(p -> p.reify(testContext));
        }
        this.serviceLocatorUtil.findAllWithFilter(CollaboratorReifier.class, new Class[]{UnitCategory.class}).forEach(p -> p.reify(testContext));
        this.serviceLocatorUtil.findAllWithFilter(FinalReifier.class, new Class[]{UnitCategory.class}).forEach(p -> p.reify(testContext));
        testDescriptor.getFieldDescriptors().forEach(p -> p.init(testInstance));
        testContext.getSutDescriptor().ifPresent(p -> p.init(testInstance));
        this.serviceLocatorUtil.findAllWithFilter(Verifier.class, guidelines, new Class[]{UnitCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
    }

    public void stop(TestContext testContext) {
        Object testInstance = testContext.getTestInstance();
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Collection guidelines = testDescriptor.getGuidelines();
        this.serviceLocatorUtil.findAllWithFilter(PostVerifier.class, guidelines, new Class[]{UnitCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
        testDescriptor.getFieldDescriptors().forEach(p -> p.destroy(testInstance));
        testContext.getSutDescriptor().ifPresent(p -> p.destroy(testInstance));
        testContext.findProperty("serviceInstance").ifPresent(ServiceInstance::destroy);
        this.resourceController.stop(testContext);
    }
}

