/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.level.integration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.testifyproject.ResourceController;
import org.testifyproject.ServiceInstance;
import org.testifyproject.ServiceProvider;
import org.testifyproject.TestConfigurer;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.TestRunner;
import org.testifyproject.annotation.Hint;
import org.testifyproject.core.util.ServiceLocatorUtil;
import org.testifyproject.extension.CollaboratorReifier;
import org.testifyproject.extension.FinalReifier;
import org.testifyproject.extension.InitialReifier;
import org.testifyproject.extension.PostVerifier;
import org.testifyproject.extension.PreVerifier;
import org.testifyproject.extension.Verifier;
import org.testifyproject.extension.annotation.IntegrationCategory;

@IntegrationCategory
public class IntegrationTestRunner
implements TestRunner {
    private final ServiceLocatorUtil serviceLocatorUtil;
    ResourceController resourceController;

    public IntegrationTestRunner() {
        this(ServiceLocatorUtil.INSTANCE);
    }

    IntegrationTestRunner(ServiceLocatorUtil serviceLocatorUtil) {
        this.serviceLocatorUtil = serviceLocatorUtil;
    }

    public void start(TestContext testContext) {
        Object testInstance = testContext.getTestInstance();
        TestConfigurer testConfigurer = testContext.getTestConfigurer();
        Optional foundSutDescriptor = testContext.getSutDescriptor();
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Collection guidelines = testDescriptor.getGuidelines();
        this.resourceController = (ResourceController)this.serviceLocatorUtil.getOne(ResourceController.class);
        this.resourceController.start(testContext);
        this.serviceLocatorUtil.findAllWithFilter(CollaboratorReifier.class, new Class[]{IntegrationCategory.class}).forEach(p -> p.reify(testContext));
        this.serviceLocatorUtil.findAllWithFilter(PreVerifier.class, guidelines, new Class[]{IntegrationCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
        ServiceProvider serviceProvider = (ServiceProvider)this.serviceLocatorUtil.getFromHintWithFilter(testContext, ServiceProvider.class, Hint::serviceProvider);
        Object serviceContext = serviceProvider.create(testContext);
        testConfigurer.configure(testContext, serviceContext);
        ServiceInstance serviceInstance = serviceProvider.configure(testContext, serviceContext);
        testContext.addProperty("serviceInstance", (Object)serviceInstance);
        foundSutDescriptor.ifPresent(sutDescriptor -> {
            Set nameQualifers = serviceInstance.getNameQualifers();
            Set customQualifiers = serviceInstance.getCustomQualifiers();
            Class sutType = sutDescriptor.getType();
            Annotation[] sutQualifiers = sutDescriptor.getMetaAnnotations(new Collection[]{nameQualifers, customQualifiers});
            Object sutInstance = serviceInstance.getService((Type)sutType, sutQualifiers);
            sutDescriptor.setValue(testInstance, sutInstance);
        });
        if (testDescriptor.getCollaboratorProvider().isPresent()) {
            this.serviceLocatorUtil.findAllWithFilter(InitialReifier.class, new Class[]{IntegrationCategory.class}).forEach(p -> p.reify(testContext));
        }
        this.serviceLocatorUtil.findAllWithFilter(FinalReifier.class, new Class[]{IntegrationCategory.class}).forEach(p -> p.reify(testContext));
        this.serviceLocatorUtil.findAllWithFilter(Verifier.class, guidelines, new Class[]{IntegrationCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
    }

    public void stop(TestContext testContext) {
        Object testInstance = testContext.getTestInstance();
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Collection guidelines = testDescriptor.getGuidelines();
        this.serviceLocatorUtil.findAllWithFilter(PostVerifier.class, guidelines, new Class[]{IntegrationCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
        testDescriptor.getFieldDescriptors().forEach(p -> p.destroy(testInstance));
        testContext.getSutDescriptor().ifPresent(p -> p.destroy(testInstance));
        if (this.resourceController != null) {
            this.resourceController.stop(testContext);
        }
        testContext.findProperty("serviceInstance").ifPresent(ServiceInstance::destroy);
    }
}

