/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.trait;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Optional;
import java.util.stream.Stream;
import org.testifyproject.TestifyException;
import org.testifyproject.guava.common.reflect.TypeToken;

public interface TypeTrait {
    public Class<?> getType();

    public Type getGenericType();

    default public String getTypeName() {
        return this.getType().getSimpleName();
    }

    default public ClassLoader getClassLoader() {
        return this.getType().getClassLoader();
    }

    default public Boolean isSubtypeOf(Type type) {
        boolean bl = TypeToken.of((Type)this.getGenericType()).isSubtypeOf(type);
        return bl ? bl : TypeToken.of(this.getType()).isSubtypeOf(type);
    }

    default public Boolean isSupertypeOf(Type type) {
        boolean bl = TypeToken.of((Type)this.getGenericType()).isSupertypeOf(type);
        return bl ? bl : TypeToken.of(this.getType()).isSupertypeOf(type);
    }

    default public <T> Optional<T> invoke(Object object, String string, Object ... objectArray) {
        return AccessController.doPrivileged(() -> {
            try {
                Class[] classArray = (Class[])Stream.of(objectArray).map(Object::getClass).toArray(Class[]::new);
                Method method = this.findMethod(object.getClass(), string, classArray);
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                return Optional.ofNullable(object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw TestifyException.of(exception);
            }
        });
    }

    default public Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        return AccessController.doPrivileged(() -> {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                Class clazz2 = clazz.getSuperclass();
                if (clazz2 == null) {
                    throw TestifyException.of(exception);
                }
                return this.findMethod(clazz2, string, classArray);
            }
        });
    }

    default public Optional<Method> findMethod(String string) {
        return AccessController.doPrivileged(() -> {
            for (Method method : this.getType().getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                return Optional.of(method);
            }
            return Optional.empty();
        });
    }
}

