/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.trait;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testifyproject.TestifyException;
import org.testifyproject.guava.common.reflect.TypeToken;
import org.testifyproject.trait.AnnotationTrait;
import org.testifyproject.trait.MemberTrait;

public interface MethodTrait
extends MemberTrait<Method>,
AnnotationTrait<Method> {
    @Override
    default public Method getAnnotatedElement() {
        return (Method)this.getMember();
    }

    default public List<Class> getParameterTypes() {
        return Stream.of(this.getAnnotatedElement().getParameterTypes()).collect(Collectors.toList());
    }

    default public List<Parameter> getParameters() {
        return Stream.of(this.getAnnotatedElement().getParameters()).collect(Collectors.toList());
    }

    default public Class<?> getReturnType() {
        return this.getAnnotatedElement().getReturnType();
    }

    default public Boolean hasReturnType(Type type) {
        TypeToken typeToken = TypeToken.of(this.getAnnotatedElement().getReturnType());
        return typeToken.isSubtypeOf(type);
    }

    default public Boolean hasParameterTypes(Type ... typeArray) {
        Method method = this.getAnnotatedElement();
        Class<?>[] classArray = method.getParameterTypes();
        boolean bl = true;
        if (typeArray.length == classArray.length) {
            for (int i = 0; i < classArray.length; ++i) {
                TypeToken typeToken = TypeToken.of(classArray[i]);
                if (typeToken.isSupertypeOf(typeArray[i])) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    default public <T> Optional<T> invoke(Object object, Object ... objectArray) {
        return AccessController.doPrivileged(() -> {
            try {
                Method method = this.getAnnotatedElement();
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                return Optional.ofNullable(object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw TestifyException.of(exception);
            }
        });
    }
}

