/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.trait;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.testifyproject.annotation.Bundle;
import org.testifyproject.guava.common.collect.ImmutableList;

public interface AnnotationTrait<T extends AnnotatedElement> {
    public T getAnnotatedElement();

    default public <A extends Annotation> Optional<A> getAnnotation(Class<A> clazz) {
        A a = this.getAnnotatedElement();
        A a2 = a.getDeclaredAnnotation(clazz);
        if (a2 == null) {
            for (Annotation annotation : a.getDeclaredAnnotations()) {
                Class<? extends Annotation> clazz2 = annotation.annotationType();
                Bundle bundle = clazz2.getDeclaredAnnotation(Bundle.class);
                if (bundle == null) continue;
                a2 = clazz2.getDeclaredAnnotation(clazz);
                break;
            }
        }
        return Optional.ofNullable(a2);
    }

    default public <A extends Annotation> List<A> getAnnotations(Class<A> clazz) {
        T t = this.getAnnotatedElement();
        Object[] objectArray = t.getDeclaredAnnotationsByType(clazz);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(objectArray);
        for (Annotation annotation : t.getDeclaredAnnotations()) {
            Class<? extends Annotation> clazz2 = annotation.annotationType();
            Bundle bundle = clazz2.getDeclaredAnnotation(Bundle.class);
            if (bundle == null) continue;
            Object[] objectArray2 = clazz2.getDeclaredAnnotationsByType(clazz);
            builder.add(objectArray2);
        }
        return builder.build();
    }

    default public Annotation[] getMetaAnnotations(Collection<Class<? extends Annotation>> ... collectionArray) {
        Object t = this.getAnnotatedElement();
        Annotation[] annotationArray = (Annotation[])((Stream)Stream.of(collectionArray).parallel()).flatMap(Collection::parallelStream).distinct().map(clazz -> {
            Object t = t.getDeclaredAnnotation(clazz);
            if (t == null) {
                for (Annotation annotation : t.getDeclaredAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent((Class<Annotation>)clazz)) continue;
                    return annotation;
                }
            }
            return t;
        }).filter(Objects::nonNull).distinct().toArray(Annotation[]::new);
        return annotationArray;
    }

    default public boolean hasAnyAnnotations(Class<? extends Annotation> ... classArray) {
        Object t = this.getAnnotatedElement();
        return ((Stream)Stream.of(classArray).parallel()).distinct().anyMatch(clazz -> t.getDeclaredAnnotation(clazz) != null);
    }

    default public boolean hasAnyAnnotations(Collection<Class<? extends Annotation>> collection) {
        T t = this.getAnnotatedElement();
        return collection.stream().map(arg_0 -> t.getDeclaredAnnotation(arg_0)).filter(Objects::nonNull).findAny().isPresent();
    }
}

