/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.processor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.testifyproject.annotation.Discoverable;

@SupportedAnnotationTypes(value={"org.testifyproject.annotation.Discoverable"})
public class DiscoverableProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        String string;
        switch (string = System.getProperty("java.specification.version")) {
            case "1.8": {
                return SourceVersion.RELEASE_8;
            }
        }
        throw new AssertionError((Object)("Version '" + string + "' not supported"));
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            return false;
        }
        HashMap hashMap = new HashMap();
        Elements elements = this.processingEnv.getElementUtils();
        roundEnvironment.getElementsAnnotatedWith(Discoverable.class).stream().filter(element -> element.getKind().isClass()).forEach(element -> {
            TypeElement typeElement2;
            Collection<TypeElement> collection;
            Discoverable discoverable = element.getAnnotation(Discoverable.class);
            if (discoverable != null && !(collection = this.getContracts(typeElement2 = (TypeElement)element, discoverable)).isEmpty()) {
                collection.stream().map(typeElement -> elements.getBinaryName((TypeElement)typeElement).toString()).map(string2 -> hashMap.computeIfAbsent(string2, string -> new TreeSet())).forEach(set -> set.add(elements.getBinaryName(typeElement2).toString()));
            }
        });
        Filer filer = this.processingEnv.getFiler();
        hashMap.entrySet().stream().forEach(entry -> {
            try {
                String string = (String)entry.getKey();
                String string2 = "META-INF/services/" + string;
                FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", string2);
                try (BufferedReader bufferedReader = new BufferedReader(fileObject.openReader(false));){
                    String string3;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        ((Set)entry.getValue()).add(string3);
                    }
                }
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        });
        hashMap.entrySet().stream().forEach(entry -> {
            try {
                String string2 = (String)entry.getKey();
                String string3 = "META-INF/services/" + string2;
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", string3, new Element[0]);
                this.note("Writing %s to %s", string3, fileObject.toUri());
                try (PrintWriter printWriter = new PrintWriter(fileObject.openWriter());){
                    ((Set)entry.getValue()).stream().forEach(string -> printWriter.println((String)string));
                    printWriter.flush();
                }
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        });
        return false;
    }

    Collection<TypeElement> getContracts(TypeElement typeElement, Discoverable discoverable) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        try {
            discoverable.value();
            throw new AssertionError();
        }
        catch (MirroredTypesException mirroredTypesException) {
            mirroredTypesException.getTypeMirrors().stream().forEach(typeMirror2 -> {
                if (typeMirror2.getKind() == TypeKind.VOID) {
                    boolean bl;
                    boolean bl2 = !this.isObject(typeElement.getSuperclass()) && typeElement.getSuperclass().getKind() != TypeKind.NONE;
                    boolean bl3 = bl = !typeElement.getInterfaces().isEmpty();
                    if (bl2) {
                        arrayList.add((TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement());
                    } else if (bl) {
                        typeElement.getInterfaces().parallelStream().map(typeMirror -> (TypeElement)((DeclaredType)typeMirror).asElement()).forEach(arrayList::add);
                    } else {
                        this.error(typeElement, "Contract type could not be inferred.", new Object[0]);
                    }
                } else if (typeMirror2 instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)typeMirror2;
                    arrayList.add((TypeElement)declaredType.asElement());
                } else {
                    this.error(typeElement, "Invalid type specified as the contract", new Object[0]);
                }
            });
            return arrayList;
        }
    }

    boolean isObject(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return ((TypeElement)declaredType.asElement()).getQualifiedName().toString().equals("java.lang.Object");
        }
        return false;
    }

    Messager getMessanger() {
        return this.processingEnv.getMessager();
    }

    void note(String string, Object ... objectArray) {
        this.getMessanger().printMessage(Diagnostic.Kind.NOTE, String.format(string, objectArray));
    }

    void warning(String string, Object ... objectArray) {
        this.getMessanger().printMessage(Diagnostic.Kind.WARNING, String.format(string, objectArray));
    }

    void error(Element element, String string, Object ... objectArray) {
        this.getMessanger().printMessage(Diagnostic.Kind.ERROR, String.format(string, objectArray), element);
    }

    void error(Throwable throwable) {
        this.getMessanger().printMessage(Diagnostic.Kind.ERROR, throwable.getMessage());
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        this.getMessanger().printMessage(Diagnostic.Kind.ERROR, stringWriter.toString());
    }
}

