/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.framework.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testfx.api.FxToolkit;
import org.testfx.util.WaitForAsyncUtils;

public class TestFXRule
extends TestWatcher {
    private final int retryCount;
    private static final long WAIT_MILLIS = 30000L;
    private boolean initialized;
    private int currentAttempt;
    private Throwable[] errors = new Throwable[0];

    public TestFXRule() {
        this.retryCount = 1;
    }

    public TestFXRule(int retryCount) {
        this.retryCount = retryCount;
    }

    public Statement apply(final Statement base, Description description) {
        this.errors = new Throwable[this.retryCount];
        return new Statement(){

            public void evaluate() throws Throwable {
                while (TestFXRule.this.currentAttempt < TestFXRule.this.retryCount) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        if (t.toString().startsWith("org.junit.AssumptionViolatedException")) {
                            return;
                        }
                        ((TestFXRule)TestFXRule.this).errors[((TestFXRule)TestFXRule.this).currentAttempt] = t;
                        TestFXRule.this.currentAttempt++;
                        Thread.sleep(1000L);
                    }
                }
                throw RetryException.from(TestFXRule.this.errors);
            }
        };
    }

    protected void starting(Description description) {
        if (!this.initialized) {
            Callable<Boolean> waitForFXThread = () -> {
                int i = 0;
                while ((long)i < 120L) {
                    if (FxToolkit.isFXApplicationThreadRunning()) {
                        return true;
                    }
                    Thread.sleep(250L);
                    ++i;
                }
                return false;
            };
            this.initialized = (Boolean)WaitForAsyncUtils.waitForAsync((long)30000L, waitForFXThread);
            if (!this.initialized) {
                throw new RuntimeException("JavaFX platform was not initialized in time");
            }
        }
    }

    private static class RetryException
    extends RuntimeException {
        private RetryException(String message) {
            super(message);
        }

        private static RetryException from(Throwable[] errors) {
            StringBuilder msg = new StringBuilder("Invoked methods still failed after " + errors.length + " attempts.");
            for (int i = 0; i < errors.length; ++i) {
                Throwable error = errors[i];
                msg.append('\n');
                msg.append("Attempt #").append(i).append(" threw exception:");
                msg.append(RetryException.stackTraceAsString(error));
            }
            return new RetryException(msg.toString());
        }

        private static String stackTraceAsString(Throwable t) {
            StringWriter errors = new StringWriter();
            t.printStackTrace(new PrintWriter(errors));
            return errors.toString();
        }
    }
}

