/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Labeled;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextInputControl;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.testfx.internal.JavaVersionAdapter;

public final class NodeQueryUtils {
    private NodeQueryUtils() {
    }

    public static Set<Node> rootsOfWindows(Collection<Window> windows) {
        return windows.stream().map(NodeQueryUtils::fromWindow).collect(Collectors.toSet());
    }

    public static Set<Node> rootOfWindow(Window ... windows) {
        return Arrays.stream(windows).map(NodeQueryUtils::fromWindow).collect(Collectors.toSet());
    }

    public static Set<Node> rootOfStage(Stage ... stages) {
        return Arrays.stream(stages).map(NodeQueryUtils::fromStage).collect(Collectors.toSet());
    }

    public static Set<Node> rootOfScene(Scene ... scenes) {
        return Arrays.stream(scenes).map(NodeQueryUtils::fromScene).collect(Collectors.toSet());
    }

    public static Set<Node> rootOfPopupControl(PopupControl ... popupControls) {
        return Arrays.stream(popupControls).map(NodeQueryUtils::fromPopupControl).collect(Collectors.toSet());
    }

    public static Function<Node, Set<Node>> bySelector(String selector) {
        return parentNode -> NodeQueryUtils.lookupWithSelector(parentNode, selector);
    }

    public static Function<Node, Set<Node>> byPredicate(Predicate<Node> predicate) {
        return parentNode -> NodeQueryUtils.lookupWithPredicate(parentNode, predicate);
    }

    public static Function<Node, Set<Node>> byMatcher(Matcher<Node> matcher) {
        return NodeQueryUtils.byPredicate(NodeQueryUtils.matchesMatcher(matcher));
    }

    public static Function<Node, Set<Node>> byText(String text) {
        return NodeQueryUtils.byPredicate(NodeQueryUtils.hasText(text));
    }

    public static Predicate<Node> hasId(String id) {
        return node -> Objects.equals(node.getId(), id);
    }

    public static Predicate<Node> hasText(String text) {
        return node -> NodeQueryUtils.hasNodeText(node, text);
    }

    public static Predicate<Node> matchesMatcher(Matcher<Node> matcher) {
        return node -> NodeQueryUtils.matchesNodeMatcher(node, matcher);
    }

    public static Predicate<Node> isVisible() {
        return NodeQueryUtils::isNodeVisible;
    }

    public static Function<Node, Set<Node>> combine(Function<Node, Set<Node>> function0, Function<Node, Set<Node>> function1) {
        ArrayList<Function<Node, Set<Node>>> functions = new ArrayList<Function<Node, Set<Node>>>();
        functions.add(function0);
        functions.add(function1);
        return input -> NodeQueryUtils.combine(input, functions);
    }

    private static Parent fromWindow(Window window) {
        return window.getScene().getRoot();
    }

    private static Parent fromStage(Stage stage) {
        return stage.getScene().getRoot();
    }

    private static Parent fromScene(Scene scene) {
        return scene.getRoot();
    }

    private static Parent fromPopupControl(PopupControl popupControl) {
        return popupControl.getScene().getRoot();
    }

    private static Set<Node> lookupWithSelector(Node parentNode, String selector) {
        return parentNode.lookupAll(selector);
    }

    private static Set<Node> lookupWithPredicate(Node parentNode, Predicate<Node> predicate) {
        LinkedHashSet<Node> resultNodes = new LinkedHashSet<Node>();
        if (NodeQueryUtils.applyPredicateSafely(predicate, parentNode)) {
            resultNodes.add(parentNode);
        }
        if (parentNode instanceof Parent) {
            ObservableList childNodes = ((Parent)parentNode).getChildrenUnmodifiable();
            for (Node childNode : childNodes) {
                resultNodes.addAll(NodeQueryUtils.lookupWithPredicate(childNode, predicate));
            }
        }
        return Collections.unmodifiableSet(resultNodes);
    }

    private static <T> boolean applyPredicateSafely(Predicate<T> predicate, T input) {
        try {
            return predicate.test(input);
        }
        catch (ClassCastException ignore) {
            return false;
        }
    }

    private static boolean hasNodeText(Node node, String text) {
        if (node instanceof Labeled) {
            return Objects.equals(((Labeled)node).getText(), text);
        }
        if (node instanceof TextInputControl) {
            return Objects.equals(((TextInputControl)node).getText(), text);
        }
        if (node instanceof Text) {
            return Objects.equals(((Text)node).getText(), text);
        }
        return false;
    }

    private static boolean matchesNodeMatcher(Node node, Matcher matcher) {
        return matcher.matches((Object)node);
    }

    private static boolean isNodeVisible(Node node) {
        return !JavaVersionAdapter.isNotVisible(node) && NodeQueryUtils.isNodeWithinSceneBounds(node);
    }

    private static boolean isNodeWithinSceneBounds(Node node) {
        Scene scene = node.getScene();
        Bounds nodeBounds = node.localToScene(node.getBoundsInLocal());
        return nodeBounds.intersects(0.0, 0.0, scene.getWidth(), scene.getHeight());
    }

    private static <T> Set<T> combine(T input, Collection<Function<T, Set<T>>> functions) {
        return functions.stream().map(f -> (Set)f.apply(input)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

