/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.support;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.stage.Stage;

public final class FiredEvents {
    private final List<Event> events = new LinkedList<Event>();
    private final Runnable removeListener;

    public static FiredEvents beginStoringFiredEventsOf(Stage stage) {
        return new FiredEvents(stage);
    }

    private FiredEvents(Stage stage) {
        if (stage == null) {
            this.removeListener = null;
        } else {
            EventHandler addFiredEvent = this.events::add;
            stage.addEventFilter(EventType.ROOT, addFiredEvent);
            this.removeListener = () -> stage.removeEventFilter(EventType.ROOT, addFiredEvent);
        }
    }

    public final List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public final void clearEvents() {
        this.events.clear();
    }

    public final void stopStoringFiredEvents() {
        if (this.removeListener != null) {
            this.removeListener.run();
        }
    }
}

