/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.locator.impl;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.testfx.service.locator.BoundsLocator;
import org.testfx.service.locator.BoundsLocatorException;

public class BoundsLocatorImpl
implements BoundsLocator {
    @Override
    public Bounds boundsInSceneFor(Node node) {
        Bounds sceneBounds = node.localToScene(node.getBoundsInLocal());
        return this.limitToVisibleBounds(sceneBounds, node.getScene());
    }

    @Override
    public Bounds boundsInWindowFor(Scene scene) {
        return new BoundingBox(scene.getX(), scene.getY(), scene.getWidth(), scene.getHeight());
    }

    @Override
    public Bounds boundsInWindowFor(Bounds boundsInScene, Scene scene) {
        Bounds visibleBoundsInScene = this.limitToVisibleBounds(boundsInScene, scene);
        Bounds windowBounds = this.boundsInWindowFor(scene);
        return this.translateBounds(visibleBoundsInScene, windowBounds.getMinX(), windowBounds.getMinY());
    }

    @Override
    public Bounds boundsOnScreenFor(Node node) {
        Bounds sceneBounds = this.boundsInSceneFor(node);
        return this.boundsOnScreenFor(sceneBounds, node.getScene());
    }

    @Override
    public Bounds boundsOnScreenFor(Scene scene) {
        Bounds windowBounds = this.boundsInWindowFor(scene);
        Window window = scene.getWindow();
        return this.translateBounds(windowBounds, window.getX(), window.getY());
    }

    @Override
    public Bounds boundsOnScreenFor(Window window) {
        return new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
    }

    @Override
    public Bounds boundsOnScreenFor(Bounds boundsInScene, Scene scene) {
        Bounds windowBounds = this.boundsInWindowFor(boundsInScene, scene);
        Window window = scene.getWindow();
        return this.translateBounds(windowBounds, window.getX(), window.getY());
    }

    private Bounds limitToVisibleBounds(Bounds boundsInScene, Scene scene) {
        BoundingBox sceneBounds = new BoundingBox(0.0, 0.0, scene.getWidth(), scene.getHeight());
        Bounds visibleBounds = this.intersectBounds(boundsInScene, (Bounds)sceneBounds);
        if (!this.areBoundsVisible(visibleBounds)) {
            throw new BoundsLocatorException("bounds are not visible in Scene");
        }
        return visibleBounds;
    }

    private Bounds intersectBounds(Bounds a, Bounds b) {
        double minX = Math.max(a.getMinX(), b.getMinX());
        double minY = Math.max(a.getMinY(), b.getMinY());
        double maxX = Math.min(a.getMaxX(), b.getMaxX());
        double maxY = Math.min(a.getMaxY(), b.getMaxY());
        double width = maxX - minX;
        double height = maxY - minY;
        return new BoundingBox(minX, minY, width, height);
    }

    private boolean areBoundsVisible(Bounds bounds) {
        return bounds.getWidth() >= 0.0 && bounds.getHeight() >= 0.0;
    }

    private Bounds translateBounds(Bounds bounds, double x, double y) {
        return new BoundingBox(bounds.getMinX() + x, bounds.getMinY() + y, bounds.getWidth(), bounds.getHeight());
    }
}

