/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.adapter.impl;

import java.lang.reflect.InvocationTargetException;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import org.testfx.internal.JavaVersionAdapter;
import org.testfx.internal.PlatformAdapter;
import org.testfx.service.adapter.impl.GlassRobotAdapter;
import org.testfx.util.WaitForAsyncUtils;

class PublicGlassRobotAdapter
extends GlassRobotAdapter {
    PublicGlassRobotAdapter() {
    }

    @Override
    public void robotCreate() {
        try {
            this.glassRobot = Class.forName("javafx.scene.robot.Robot").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void robotDestroy() {
    }

    @Override
    public void keyPress(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("keyPress", KeyCode.class).invoke(this.getRobot(), key));
    }

    @Override
    public void keyRelease(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("keyRelease", KeyCode.class).invoke(this.getRobot(), key));
    }

    @Override
    public Point2D getMouseLocation() {
        if (PlatformAdapter.getOs() == PlatformAdapter.OS.UNIX && !JavaVersionAdapter.currentVersion().isJava11Compatible()) {
            return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> new Point2D((double)((Double)this.getRobot().getClass().getMethod("getMouseX", new Class[0]).invoke(this.getRobot(), new Object[0])).intValue() / JavaVersionAdapter.getScreenScaleX(), (double)((Double)this.getRobot().getClass().getMethod("getMouseY", new Class[0]).invoke(this.getRobot(), new Object[0])).intValue() / JavaVersionAdapter.getScreenScaleY()));
        }
        return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> new Point2D((double)((Double)this.getRobot().getClass().getMethod("getMouseX", new Class[0]).invoke(this.glassRobot, new Object[0])).intValue(), (double)((Double)this.getRobot().getClass().getMethod("getMouseY", new Class[0]).invoke(this.glassRobot, new Object[0])).intValue()));
    }

    @Override
    public void mouseMove(Point2D location) {
        Rectangle2D scaled = new Rectangle2D(location.getX(), location.getY(), 0.0, 0.0);
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mouseMove", Double.TYPE, Double.TYPE).invoke(this.getRobot(), (int)scaled.getMinX(), (int)scaled.getMinY()));
    }

    @Override
    public void mousePress(MouseButton button) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mousePress", MouseButton[].class).invoke(this.getRobot(), new Object[]{new MouseButton[]{button}}));
    }

    @Override
    public void mouseRelease(MouseButton button) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mouseRelease", MouseButton[].class).invoke(this.getRobot(), new Object[]{new MouseButton[]{button}}));
    }

    @Override
    public Color getCapturePixelColor(Point2D location) {
        Rectangle2D scaled = new Rectangle2D(location.getX(), location.getY(), 0.0, 0.0);
        return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> (Color)this.getRobot().getClass().getMethod("getPixelColor", Double.TYPE, Double.TYPE).invoke(this.getRobot(), scaled.getMinX(), scaled.getMinY()));
    }

    @Override
    protected Image getScreenCapture(Rectangle2D region, boolean raw) {
        return (Image)WaitForAsyncUtils.waitForAsyncFx(10000L, () -> (WritableImage)this.getRobot().getClass().getMethod("getScreenCapture", WritableImage.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE).invoke(this.glassRobot, null, region.getMinX(), region.getMinY(), region.getWidth(), region.getHeight(), !raw));
    }
}

