/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.geometry.Point2D;
import org.testfx.robot.BaseRobot;
import org.testfx.robot.Motion;
import org.testfx.robot.MouseRobot;
import org.testfx.robot.MoveRobot;
import org.testfx.robot.SleepRobot;
import org.testfx.service.query.PointQuery;

public class MoveRobotImpl
implements MoveRobot {
    private static final long SLEEP_AFTER_MOVEMENT_STEP_IN_MILLIS = 1L;
    private static final long MIN_POINT_OFFSET_COUNT = 1L;
    private static final long MAX_POINT_OFFSET_COUNT;
    private final BaseRobot baseRobot;
    private final MouseRobot mouseRobot;
    private final SleepRobot sleepRobot;

    public MoveRobotImpl(BaseRobot baseRobot, MouseRobot mouseRobot, SleepRobot sleepRobot) {
        this.baseRobot = baseRobot;
        this.mouseRobot = mouseRobot;
        this.sleepRobot = sleepRobot;
    }

    @Override
    public void moveTo(PointQuery pointQuery, Motion motion) {
        Point2D targetPoint;
        Point2D sourcePoint = this.baseRobot.retrieveMouse();
        if (motion == Motion.DEFAULT && pointQuery.queryMotion().isPresent()) {
            motion = pointQuery.queryMotion().get();
        }
        if (sourcePoint != (targetPoint = pointQuery.query())) {
            this.moveMouseStepwiseBetween(sourcePoint, targetPoint, motion);
        }
        Point2D finalPoint = pointQuery.query();
        this.mouseRobot.move(finalPoint);
    }

    @Override
    public void moveBy(double x, double y, Motion motion) {
        Point2D sourcePoint = this.baseRobot.retrieveMouse();
        Point2D targetPoint = new Point2D(sourcePoint.getX() + x, sourcePoint.getY() + y);
        this.moveMouseStepwiseBetween(sourcePoint, targetPoint, motion);
    }

    private void moveMouseStepwiseBetween(Point2D sourcePoint, Point2D targetPoint, Motion motion) {
        if (motion == Motion.DEFAULT) {
            motion = Motion.DIRECT;
        }
        double directDistance = sourcePoint.distance(targetPoint);
        double horizontalDistance = sourcePoint.distance(targetPoint.getX(), sourcePoint.getY());
        double verticalDistance = sourcePoint.distance(sourcePoint.getX(), targetPoint.getY());
        int totalStepsCount = (int)this.limitValueBetween(directDistance, 1.0, MAX_POINT_OFFSET_COUNT);
        List<Object> path = new ArrayList(totalStepsCount);
        double percentHorizontal = horizontalDistance / (horizontalDistance + verticalDistance);
        int horizontalStepsCount = (int)((double)totalStepsCount * percentHorizontal);
        int verticalStepsCount = totalStepsCount - horizontalStepsCount;
        switch (motion) {
            case DIRECT: {
                path = this.interpolatePointsBetween(sourcePoint, targetPoint, totalStepsCount);
                break;
            }
            case HORIZONTAL_FIRST: {
                Point2D intermediate = new Point2D(targetPoint.getX(), sourcePoint.getY());
                path = Stream.concat(this.interpolatePointsBetween(sourcePoint, intermediate, horizontalStepsCount).stream(), this.interpolatePointsBetween(intermediate, targetPoint, verticalStepsCount).stream()).collect(Collectors.toList());
                break;
            }
            case VERTICAL_FIRST: {
                Point2D intermediate = new Point2D(sourcePoint.getX(), targetPoint.getY());
                path = Stream.concat(this.interpolatePointsBetween(sourcePoint, intermediate, verticalStepsCount).stream(), this.interpolatePointsBetween(intermediate, targetPoint, horizontalStepsCount).stream()).collect(Collectors.toList());
                break;
            }
        }
        for (int i = 0; i < path.size() - 1; ++i) {
            Point2D point = (Point2D)path.get(i);
            this.mouseRobot.moveNoWait(point);
            this.sleepRobot.sleep(1L);
        }
        this.mouseRobot.move(targetPoint);
    }

    private List<Point2D> interpolatePointsBetween(Point2D sourcePoint, Point2D targetPoint, int pointOffsetCount) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int pointOffset = 1; pointOffset <= pointOffsetCount; ++pointOffset) {
            double factor = (double)pointOffset / (double)pointOffsetCount;
            Point2D point = this.interpolatePointBetween(sourcePoint, targetPoint, factor);
            points.add(point);
        }
        return Collections.unmodifiableList(points);
    }

    private double limitValueBetween(double value, double minValue, double maxValue) {
        return Math.max(minValue, Math.min(maxValue, value));
    }

    private Point2D interpolatePointBetween(Point2D point0, Point2D point1, double factor) {
        double x = this.interpolateValuesBetween(point0.getX(), point1.getX(), factor);
        double y = this.interpolateValuesBetween(point0.getY(), point1.getY(), factor);
        return new Point2D(x, y);
    }

    private double interpolateValuesBetween(double value0, double value1, double factor) {
        return value0 + (value1 - value0) * factor;
    }

    static {
        int maxOffsetCount;
        try {
            maxOffsetCount = Integer.getInteger("testfx.robot.move_max_count", 200);
        }
        catch (NumberFormatException e) {
            System.err.println("\"testfx.robot.move_max_count\" property must be a number but was: \"" + System.getProperty("testfx.robot.move_max_count") + "\".\nUsing default of \"200\".");
            e.printStackTrace();
            maxOffsetCount = 200;
        }
        MAX_POINT_OFFSET_COUNT = maxOffsetCount;
    }
}

