/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListView;
import org.hamcrest.Matcher;
import org.testfx.api.FxAssert;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.query.NodeQuery;

public class ListViewMatchers {
    private static final String SELECTOR_LIST_CELL = ".list-cell";

    private ListViewMatchers() {
    }

    public static Matcher<ListView> hasListCell(Object value) {
        String descriptionText = "has list cell \"" + value + "\"";
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, ListViewMatchers::getItemsString, listView -> ListViewMatchers.hasListCell(listView, value));
    }

    public static Matcher<ListView> hasItems(int amount) {
        String descriptionText = "has exactly " + amount + ' ' + (amount == 1 ? "item" : "items");
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, listView -> String.valueOf(listView.getItems().size()), listView -> listView.getItems().size() == amount);
    }

    public static Matcher<ListView> isEmpty() {
        String descriptionText = "is empty (contains no items)";
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, listView -> listView.getItems().size() == 0 ? "empty" : "contains " + listView.getItems().size() + " items", listView -> listView.getItems().isEmpty());
    }

    public static Matcher<ListView> hasPlaceholder(Node placeHolder) {
        String descriptionText = "has " + ListViewMatchers.getPlaceHolderDescription(placeHolder, false);
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, listView -> ListViewMatchers.getPlaceHolderDescription(listView.getPlaceholder(), false), listView -> ListViewMatchers.hasPlaceholder(listView, placeHolder));
    }

    public static Matcher<ListView> hasVisiblePlaceholder(Node placeHolder) {
        String descriptionText = "has " + ListViewMatchers.getPlaceHolderDescription(placeHolder, true);
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, listView -> ListViewMatchers.getPlaceHolderDescription(listView.getPlaceholder(), true), node -> ListViewMatchers.hasVisiblePlaceholder(node, placeHolder));
    }

    public static Matcher<ListView> hasSelectedRow(Object value) {
        String descriptionText = String.format("has selection \"%s\"", value);
        return GeneralMatchers.typeSafeMatcher(ListView.class, descriptionText, listView -> "\"" + listView.getSelectionModel().getSelectedItems().toString() + "\"", listView -> ListViewMatchers.hasSelectedItem(listView, value));
    }

    private static boolean hasSelectedItem(ListView<?> listView, Object value) {
        return listView.getSelectionModel().getSelectedItems().contains(value);
    }

    private static boolean hasListCell(ListView listView, Object value) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        NodeQuery nodeQuery = nodeFinder.from(new Node[]{listView});
        return nodeQuery.lookup(SELECTOR_LIST_CELL).match(cell -> ListViewMatchers.hasCellValue(cell, value)).tryQuery().isPresent();
    }

    private static boolean hasCellValue(Cell cell, Object value) {
        return !cell.isEmpty() && Objects.equals(cell.getItem(), value);
    }

    private static boolean hasPlaceholder(ListView listView, Node placeHolder) {
        if (Labeled.class.isAssignableFrom(placeHolder.getClass()) && Labeled.class.isAssignableFrom(listView.getPlaceholder().getClass())) {
            return ((Labeled)listView.getPlaceholder()).getText().equals(((Labeled)placeHolder).getText());
        }
        return Objects.equals(listView.getPlaceholder(), placeHolder);
    }

    private static boolean hasVisiblePlaceholder(ListView listView, Node placeHolder) {
        return listView.getPlaceholder().isVisible() && ListViewMatchers.hasPlaceholder(listView, placeHolder);
    }

    private static String getItemsString(ListView<?> listView) {
        StringBuilder items = new StringBuilder("[");
        for (int i = 0; i < listView.getItems().size(); ++i) {
            items.append(listView.getItems().get(i).toString());
            if (i >= listView.getItems().size() - 1) continue;
            items.append(", ");
        }
        items.append("]");
        return items.toString();
    }

    private static String getPlaceHolderDescription(Node placeHolder, boolean describeVisibility) {
        if (Labeled.class.isAssignableFrom(placeHolder.getClass())) {
            return (describeVisibility ? (placeHolder.isVisible() ? "visible " : "invisible ") : "") + "labeled placeholder containing text: \"" + ((Labeled)placeHolder).getText() + "\"";
        }
        return (describeVisibility ? (placeHolder.isVisible() ? "visible " : "invisible ") : "") + "placeholder " + placeHolder;
    }
}

