/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.internal;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.stage.Screen;
import javafx.stage.Window;

public final class JavaVersionAdapter {
    private static JavaVersion currentJavaVersion;

    private JavaVersionAdapter() {
    }

    public static int convertToKeyCodeId(KeyCode keyCode) {
        Method getCode;
        if (JavaVersionAdapter.currentVersion().isJava8()) {
            try {
                getCode = keyCode.getClass().getMethod("impl_getCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else if (JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            try {
                getCode = keyCode.getClass().getMethod("getCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("bad java version: " + (Object)((Object)JavaVersionAdapter.currentVersion()));
        }
        try {
            return (Integer)getCode.invoke((Object)keyCode, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Window> getWindows() {
        ArrayList<Window> windows;
        if (JavaVersionAdapter.currentVersion().isJava8()) {
            try {
                windows = new ArrayList<Window>();
                ((Iterator)Window.class.getMethod("impl_getWindows", new Class[0]).invoke(null, new Object[0])).forEachRemaining(windows::add);
                Collections.reverse(windows);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else if (JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            try {
                windows = new ArrayList((ObservableList)Window.class.getMethod("getWindows", new Class[0]).invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("bad java version: " + (Object)((Object)JavaVersionAdapter.currentVersion()));
        }
        return windows;
    }

    public static boolean isNotVisible(Node node) {
        if (JavaVersionAdapter.currentVersion().isJava8()) {
            try {
                boolean treeVisible = (Boolean)node.getClass().getMethod("impl_isTreeVisible", new Class[0]).invoke((Object)node, new Object[0]);
                return !node.isVisible() || !treeVisible;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            return !node.isVisible();
        }
        throw new RuntimeException("bad java version: " + (Object)((Object)JavaVersionAdapter.currentVersion()));
    }

    public static double getScreenScaleX() {
        if (JavaVersionAdapter.currentVersion().isJava8()) {
            double scaledWidth;
            if (GraphicsEnvironment.isHeadless()) {
                return 1.0;
            }
            Rectangle primaryScreenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            double realWidth = primaryScreenRect.getWidth();
            if (Math.abs(realWidth - (scaledWidth = Screen.getPrimary().getBounds().getWidth())) <= 0.001) {
                return 1.0;
            }
            return realWidth / scaledWidth;
        }
        if (JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            try {
                return (Double)Screen.class.getMethod("getOutputScaleX", new Class[0]).invoke((Object)Screen.getPrimary(), new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("bad java version: " + (Object)((Object)JavaVersionAdapter.currentVersion()));
    }

    public static double getScreenScaleY() {
        if (JavaVersionAdapter.currentVersion().isJava8()) {
            double scaledHeight;
            if (GraphicsEnvironment.isHeadless()) {
                return 1.0;
            }
            Rectangle primaryScreenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            double realHeight = primaryScreenRect.getHeight();
            if (Math.abs(realHeight - (scaledHeight = Screen.getPrimary().getBounds().getHeight())) <= 0.001) {
                return 1.0;
            }
            return realHeight / scaledHeight;
        }
        if (JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            try {
                return (Double)Screen.class.getMethod("getOutputScaleY", new Class[0]).invoke((Object)Screen.getPrimary(), new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("bad java version: " + (Object)((Object)JavaVersionAdapter.currentVersion()));
    }

    public static JavaVersion currentVersion() {
        if (currentJavaVersion == null) {
            currentJavaVersion = JavaVersionAdapter.toVersion(System.getProperty("java.version"));
        }
        return currentJavaVersion;
    }

    private static JavaVersion toVersion(String javaVersion) throws IllegalArgumentException {
        Objects.requireNonNull(javaVersion, "javaVersion must not be null");
        int firstNonVersionCharIndex = javaVersion.length();
        for (int i = 0; i < javaVersion.length(); ++i) {
            char c = javaVersion.charAt(i);
            if (c >= '0' && c <= '9' || c == '.') continue;
            firstNonVersionCharIndex = i;
            break;
        }
        String[] versionStrings = javaVersion.substring(0, firstNonVersionCharIndex).split("\\.");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String versionString : versionStrings) {
            try {
                result.add(Integer.parseInt(versionString));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        if ((Integer)result.get(0) == 1 && result.size() > 1) {
            return JavaVersionAdapter.getVersionForMajor((Integer)result.get(1));
        }
        return JavaVersionAdapter.getVersionForMajor((Integer)result.get(0));
    }

    private static JavaVersion getVersionForMajor(int major) {
        return major >= JavaVersion.values().length ? JavaVersion.VERSION_HIGHER : JavaVersion.values()[major - 1];
    }

    public static enum JavaVersion {
        VERSION_1_1,
        VERSION_1_2,
        VERSION_1_3,
        VERSION_1_4,
        VERSION_1_5,
        VERSION_1_6,
        VERSION_1_7,
        VERSION_1_8,
        VERSION_1_9,
        VERSION_1_10,
        VERSION_11,
        VERSION_HIGHER;

        private static final int FIRST_MAJOR_VERSION_ORDINAL = 10;
        private final String versionName = this.ordinal() >= 10 ? this.getMajorVersion() : "1." + this.getMajorVersion();

        public String getMajorVersion() {
            return String.valueOf(this.ordinal() + 1);
        }

        private boolean isJava8() {
            return this == VERSION_1_8;
        }

        public boolean isJava9Compatible() {
            return this.compareTo(VERSION_1_9) >= 0;
        }

        public boolean isJava11Compatible() {
            return this.compareTo(VERSION_11) >= 0;
        }

        public String toString() {
            return this.versionName;
        }
    }
}

