/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import javafx.geometry.Pos;
import org.testfx.api.FxService;
import org.testfx.robot.BaseRobot;
import org.testfx.robot.ClickRobot;
import org.testfx.robot.DragRobot;
import org.testfx.robot.KeyboardRobot;
import org.testfx.robot.MouseRobot;
import org.testfx.robot.MoveRobot;
import org.testfx.robot.ScrollRobot;
import org.testfx.robot.SleepRobot;
import org.testfx.robot.TypeRobot;
import org.testfx.robot.WriteRobot;
import org.testfx.robot.impl.BaseRobotImpl;
import org.testfx.robot.impl.ClickRobotImpl;
import org.testfx.robot.impl.DragRobotImpl;
import org.testfx.robot.impl.KeyboardRobotImpl;
import org.testfx.robot.impl.MouseRobotImpl;
import org.testfx.robot.impl.MoveRobotImpl;
import org.testfx.robot.impl.ScrollRobotImpl;
import org.testfx.robot.impl.SleepRobotImpl;
import org.testfx.robot.impl.TypeRobotImpl;
import org.testfx.robot.impl.WriteRobotImpl;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.finder.WindowFinder;
import org.testfx.service.locator.BoundsLocator;
import org.testfx.service.locator.PointLocator;
import org.testfx.service.locator.impl.BoundsLocatorImpl;
import org.testfx.service.locator.impl.PointLocatorImpl;
import org.testfx.service.support.CaptureSupport;
import org.testfx.service.support.impl.CaptureSupportImpl;

public class FxRobotContext {
    private final WindowFinder windowFinder = FxService.serviceContext().getWindowFinder();
    private final NodeFinder nodeFinder = FxService.serviceContext().getNodeFinder();
    private final BoundsLocator boundsLocator = new BoundsLocatorImpl();
    private final PointLocator pointLocator = new PointLocatorImpl(this.boundsLocator);
    private final BaseRobot baseRobot = new BaseRobotImpl();
    private final MouseRobot mouseRobot;
    private final KeyboardRobot keyboardRobot = new KeyboardRobotImpl(this.baseRobot);
    private final MoveRobot moveRobot;
    private final SleepRobot sleepRobot;
    private final ClickRobot clickRobot;
    private final DragRobot dragRobot;
    private final ScrollRobot scrollRobot;
    private final TypeRobot typeRobot;
    private final WriteRobot writeRobot;
    private final CaptureSupport captureSupport;
    private Pos pointPosition;

    public FxRobotContext() {
        this.mouseRobot = new MouseRobotImpl(this.baseRobot);
        this.sleepRobot = new SleepRobotImpl();
        this.typeRobot = new TypeRobotImpl(this.keyboardRobot, this.sleepRobot);
        this.writeRobot = new WriteRobotImpl(this.baseRobot, this.sleepRobot, this.windowFinder);
        this.moveRobot = new MoveRobotImpl(this.baseRobot, this.mouseRobot, this.sleepRobot);
        this.clickRobot = new ClickRobotImpl(this.mouseRobot, this.moveRobot, this.sleepRobot);
        this.dragRobot = new DragRobotImpl(this.mouseRobot, this.moveRobot);
        this.scrollRobot = new ScrollRobotImpl(this.mouseRobot);
        this.captureSupport = new CaptureSupportImpl(this.baseRobot);
        this.pointPosition = Pos.CENTER;
    }

    public WindowFinder getWindowFinder() {
        return this.windowFinder;
    }

    public NodeFinder getNodeFinder() {
        return this.nodeFinder;
    }

    public Pos getPointPosition() {
        return this.pointPosition;
    }

    public void setPointPosition(Pos pointPosition) {
        this.pointPosition = pointPosition;
    }

    public BoundsLocator getBoundsLocator() {
        return this.boundsLocator;
    }

    public PointLocator getPointLocator() {
        return this.pointLocator;
    }

    public BaseRobot getBaseRobot() {
        return this.baseRobot;
    }

    public MouseRobot getMouseRobot() {
        return this.mouseRobot;
    }

    public KeyboardRobot getKeyboardRobot() {
        return this.keyboardRobot;
    }

    public MoveRobot getMoveRobot() {
        return this.moveRobot;
    }

    public SleepRobot getSleepRobot() {
        return this.sleepRobot;
    }

    public ClickRobot getClickRobot() {
        return this.clickRobot;
    }

    public DragRobot getDragRobot() {
        return this.dragRobot;
    }

    public ScrollRobot getScrollRobot() {
        return this.scrollRobot;
    }

    public TypeRobot getTypeRobot() {
        return this.typeRobot;
    }

    public WriteRobot getWriteRobot() {
        return this.writeRobot;
    }

    public CaptureSupport getCaptureSupport() {
        return this.captureSupport;
    }
}

