/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.support.impl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Shape;
import javax.imageio.ImageIO;
import org.testfx.robot.BaseRobot;
import org.testfx.service.support.CaptureSupport;
import org.testfx.service.support.PixelMatcher;
import org.testfx.service.support.PixelMatcherResult;
import org.testfx.util.WaitForAsyncUtils;

public class CaptureSupportImpl
implements CaptureSupport {
    public static final String PNG_IMAGE_FORMAT = "png";
    private BaseRobot baseRobot;

    public CaptureSupportImpl(BaseRobot baseRobot) {
        this.baseRobot = baseRobot;
    }

    @Override
    public Image captureNode(Node node) {
        return WaitForAsyncUtils.waitFor(WaitForAsyncUtils.asyncFx(() -> this.snapshotNodeToImage(node)));
    }

    @Override
    public Image captureRegion(Rectangle2D region) {
        return this.baseRobot.captureRegion(region);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Image loadImage(Path path) {
        this.checkFileExists(path);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Image image = this.readImageFromStream(inputStream);
            return image;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void saveImage(Image image, Path path) {
        this.checkParentDirectoryExists(path);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.writeImageToStream(image, outputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Image annotateImage(Shape shape, Image image) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PixelMatcherResult matchImages(Image image0, Image image1, PixelMatcher pixelMatcher) {
        return pixelMatcher.match(image0, image1);
    }

    private void checkFileExists(Path path) {
        if (!path.toFile().isFile()) {
            throw new RuntimeException("File " + path.getFileName() + " not found.");
        }
    }

    private void checkParentDirectoryExists(Path path) {
        if (!path.toAbsolutePath().getParent().toFile().isDirectory()) {
            throw new RuntimeException("Directory " + path.getFileName() + " not found.");
        }
    }

    private Image snapshotNodeToImage(Node node) {
        return node.snapshot(null, null);
    }

    private Image readImageFromStream(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
    }

    private void writeImageToStream(Image image, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
        ImageIO.write((RenderedImage)bufferedImage, PNG_IMAGE_FORMAT, outputStream);
    }

    private Image blendImages(Image image0, Image image1, BlendMode blendMode, Pos alignment) {
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(alignment);
        stackPane.setBlendMode(blendMode);
        stackPane.getChildren().add((Object)new ImageView(image0));
        stackPane.getChildren().add((Object)new ImageView(image1));
        return this.captureNode((Node)stackPane);
    }
}

