/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.util.ColorUtils;

public class TextFlowMatchers {
    private TextFlowMatchers() {
    }

    @Factory
    public static Matcher<TextFlow> hasText(String string) {
        String descriptionText = "has text \"" + string + "\"";
        return GeneralMatchers.typeSafeMatcher(TextFlow.class, descriptionText, textFlow -> "TextFlow containing text: \"" + TextFlowMatchers.getText(textFlow) + "\"", node -> TextFlowMatchers.hasText(node, string));
    }

    @Factory
    public static Matcher<TextFlow> hasColoredText(String coloredTextMarkup) {
        String descriptionText = "has colored text \"" + coloredTextMarkup + "\"";
        return GeneralMatchers.typeSafeMatcher(TextFlow.class, descriptionText, textFlow -> "TextFlow with colored text: \"" + TextFlowMatchers.getColoredTextMarkup(textFlow, false) + "\"", node -> TextFlowMatchers.hasColoredText(node, coloredTextMarkup, false));
    }

    @Factory
    public static Matcher<TextFlow> hasExactlyColoredText(String coloredTextMarkup) {
        String descriptionText = "has exactly colored text \"" + coloredTextMarkup + "\"";
        return GeneralMatchers.typeSafeMatcher(TextFlow.class, descriptionText, textFlow -> {
            for (Node child : textFlow.getChildren()) {
                if (!Text.class.isAssignableFrom(child.getClass())) continue;
                Text text = (Text)child;
                Paint fill = text.getFill();
                if (Color.class.isAssignableFrom(fill.getClass())) {
                    String textColor = fill.toString().substring(2, 8);
                    if (ColorUtils.getNamedColor((Color)fill).isPresent()) continue;
                    return "impossible to exactly match TextFlow containing colored text: \"" + ((Text)child).getText() + "\" which has color: \"#" + textColor + "\".\nThis is not a named color. The closest named color is: \"" + ColorUtils.getClosestNamedColor(Integer.parseInt(textColor, 16)) + "\".\nSee: https://docs.oracle.com/javase/9/docs/api/javafx/scene/doc-files/cssref.html#typecolor";
                }
                return "exact color matching for subclasses of javafx.scene.paint.Paint besides javafx.scene.paint.Color is not (yet) supported.";
            }
            return TextFlowMatchers.getColoredTextMarkup(textFlow, true);
        }, node -> TextFlowMatchers.hasColoredText(node, coloredTextMarkup, true));
    }

    private static String getText(TextFlow textFlow) {
        StringBuilder textBuilder = new StringBuilder();
        for (Node child : textFlow.getChildren()) {
            if (!Text.class.isAssignableFrom(child.getClass())) continue;
            textBuilder.append(((Text)child).getText());
        }
        return textBuilder.toString();
    }

    private static boolean hasText(TextFlow textFlow, String string) {
        return Objects.equals(string, TextFlowMatchers.getText(textFlow));
    }

    private static boolean hasColoredText(TextFlow textFlow, String string, boolean exact) {
        String textColorMarkup = TextFlowMatchers.getColoredTextMarkup(textFlow, exact);
        return textColorMarkup != null && Objects.equals(string, textColorMarkup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getColoredTextMarkup(TextFlow textFlow, boolean exact) {
        StringBuilder coloredTextMarkup = new StringBuilder();
        for (Node child : textFlow.getChildren()) {
            String color;
            if (!Text.class.isAssignableFrom(child.getClass())) continue;
            Text text = (Text)child;
            if (exact) {
                Paint fill = text.getFill();
                if (!Color.class.isAssignableFrom(fill.getClass())) return null;
                Optional<String> colorOptional = ColorUtils.getNamedColor(Integer.parseInt(text.getFill().toString().substring(2, 8), 16));
                if (!colorOptional.isPresent()) return null;
                color = colorOptional.get().toUpperCase(Locale.US);
            } else {
                color = ColorUtils.getClosestNamedColor(Integer.parseInt(text.getFill().toString().substring(2, 8), 16));
            }
            if (!color.equals("BLACK")) {
                coloredTextMarkup.append("<").append(color).append(">");
            }
            coloredTextMarkup.append(text.getText());
            if (color.equals("BLACK")) continue;
            coloredTextMarkup.append("</").append(color).append(">");
        }
        return coloredTextMarkup.toString();
    }
}

