/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.api.FxAssert;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.query.NodeQuery;

public class TableViewMatchers {
    private static final String SELECTOR_TABLE_CELL = ".table-cell";

    private TableViewMatchers() {
    }

    @Factory
    public static Matcher<TableView> hasTableCell(Object value) {
        String descriptionText = "has table cell \"" + value + "\"";
        return GeneralMatchers.typeSafeMatcher(TableView.class, descriptionText, TableViewMatchers::toText, tableView -> TableViewMatchers.hasTableCell(tableView, value));
    }

    @Factory
    @Deprecated
    public static Matcher<TableView> hasItems(int rows) {
        String descriptionText = "has " + rows + " rows";
        return GeneralMatchers.typeSafeMatcher(TableView.class, descriptionText, tableView -> String.valueOf(tableView.getItems().size()), tableView -> tableView.getItems().size() == rows);
    }

    @Factory
    public static Matcher<TableView> hasNumRows(int rows) {
        String descriptionText = "has " + rows + " rows";
        return GeneralMatchers.typeSafeMatcher(TableView.class, descriptionText, tableView -> "contained " + (tableView.getItems().isEmpty() ? "no" : String.valueOf(tableView.getItems().size()) + ' ' + (tableView.getItems().size() == 1 ? "row" : "rows")), tableView -> tableView.getItems().size() == rows);
    }

    @Factory
    public static Matcher<TableView> containsRowAtIndex(int rowIndex, Object ... cells) {
        String descriptionText = String.format("has row: %s at index %d", Arrays.toString(cells), rowIndex);
        return GeneralMatchers.typeSafeMatcher(TableView.class, descriptionText, tableView -> {
            if (rowIndex < 0) {
                return "given negative row index: " + rowIndex;
            }
            if (rowIndex >= tableView.getItems().size()) {
                return "given out-of-bounds row index: " + rowIndex + " (table only has " + tableView.getItems().size() + " rows)";
            }
            return TableViewMatchers.toText(tableView, rowIndex) + " at index: " + rowIndex;
        }, tableView -> TableViewMatchers.containsRowAtIndex(tableView, rowIndex, cells));
    }

    @Factory
    public static Matcher<TableView> containsRow(Object ... cells) {
        String descriptionText = "has row: " + Arrays.toString(cells);
        return GeneralMatchers.typeSafeMatcher(TableView.class, descriptionText, TableViewMatchers::toText, tableView -> TableViewMatchers.containsRow(tableView, cells));
    }

    private static boolean hasTableCell(TableView tableView, Object value) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        NodeQuery nodeQuery = nodeFinder.from(new Node[]{tableView});
        return nodeQuery.lookup(SELECTOR_TABLE_CELL).match(cell -> TableViewMatchers.hasCellValue(cell, value)).tryQuery().isPresent();
    }

    private static <T> boolean containsRowAtIndex(TableView<T> tableView, int rowIndex, Object ... cells) {
        if (rowIndex < 0 || rowIndex >= tableView.getItems().size()) {
            return false;
        }
        List<ObservableValue<?>> rowValues = TableViewMatchers.getRowValues(tableView, rowIndex);
        for (int i = 0; i < cells.length; ++i) {
            if (!(rowValues.get(i).getValue() == null ? cells[i] != null : !rowValues.get(i).getValue().equals(cells[i]))) continue;
            return false;
        }
        return true;
    }

    private static List<ObservableValue<?>> getRowValues(TableView<?> tableView, int rowIndex) {
        Object rowObject = tableView.getItems().get(rowIndex);
        ArrayList rowValues = new ArrayList(tableView.getColumns().size());
        for (int i = 0; i < tableView.getColumns().size(); ++i) {
            TableColumn column = (TableColumn)tableView.getColumns().get(i);
            TableColumn.CellDataFeatures cellDataFeatures = new TableColumn.CellDataFeatures(tableView, column, rowObject);
            rowValues.add(i, (ObservableValue<?>)column.getCellValueFactory().call((Object)cellDataFeatures));
        }
        return rowValues;
    }

    private static String toText(TableView<?> tableView) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (int rowIndex = 0; rowIndex < tableView.getItems().size(); ++rowIndex) {
            joiner.add(TableViewMatchers.toText(tableView, rowIndex));
        }
        return joiner.toString();
    }

    private static String toText(TableView<?> tableView, int rowIndex) {
        return '[' + TableViewMatchers.getRowValues(tableView, rowIndex).stream().map(observableValue -> observableValue.getValue() == null ? "null" : observableValue.getValue().toString()).collect(Collectors.joining(", ")) + ']';
    }

    private static <T> boolean containsRow(TableView<T> tableView, Object ... cells) {
        if (tableView.getItems().isEmpty()) {
            return false;
        }
        HashMap<Integer, List> rowValuesMap = new HashMap<Integer, List>(tableView.getColumns().size());
        for (int j = 0; j < tableView.getItems().size(); ++j) {
            List rowValues = TableViewMatchers.getRowValues(tableView, j);
            rowValuesMap.put(j, rowValues);
        }
        block1: for (List rowValues : rowValuesMap.values()) {
            for (int i = 0; !(i >= cells.length || ((ObservableValue)rowValues.get(i)).getValue() == null && cells[i] != null || cells[i] == null && ((ObservableValue)rowValues.get(i)).getValue() != null || ((ObservableValue)rowValues.get(i)).getValue() != null && !((ObservableValue)rowValues.get(i)).getValue().equals(cells[i])); ++i) {
                if (i != cells.length - 1) continue;
                if (((ObservableValue)rowValues.get(i)).getValue() == null && cells[i] != null || cells[i] == null && ((ObservableValue)rowValues.get(i)).getValue() != null) continue block1;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCellValue(Cell cell, Object value) {
        return !cell.isEmpty() && TableViewMatchers.hasItemValue(cell.getText(), value);
    }

    private static boolean hasItemValue(Object item, Object value) {
        if (item == null && value == null) {
            return true;
        }
        if (item == null || value == null) {
            return false;
        }
        return Objects.equals(item, value) || Objects.equals(item.toString(), value) || value.toString() != null && Objects.equals(item.toString(), value.toString());
    }
}

