/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.Arrays;
import javafx.scene.control.ComboBox;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;

public class ComboBoxMatchers {
    private ComboBoxMatchers() {
    }

    @Factory
    public static Matcher<ComboBox> hasItems(int amount) {
        String descriptionText = "has exactly " + amount + " items";
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, comboBox -> String.valueOf(comboBox.getItems().size()), comboBox -> comboBox.getItems().size() == amount);
    }

    @Factory
    public static <T> Matcher<ComboBox> hasSelectedItem(T selection) {
        String descriptionText = String.format("has selection \"%s\"", selection);
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, comboBox -> "\"" + comboBox.getSelectionModel().getSelectedItem().toString() + "\"", comboBox -> ComboBoxMatchers.hasSelectedItem(comboBox, selection));
    }

    @Factory
    public static <T> Matcher<ComboBox> containsItems(T ... items) {
        String descriptionText = "contains items " + Arrays.toString(items);
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, ComboBoxMatchers::getItemsString, comboBox -> ComboBoxMatchers.containsItems(comboBox, items));
    }

    @Factory
    public static <T> Matcher<ComboBox> containsExactlyItems(T ... items) {
        String descriptionText = "contains exactly items " + Arrays.toString(items);
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, ComboBoxMatchers::getItemsString, comboBox -> ComboBoxMatchers.containsExactlyItems(comboBox, items));
    }

    @Factory
    public static <T> Matcher<ComboBox> containsItemsInOrder(T ... items) {
        String descriptionText = "contains items in order " + Arrays.toString(items);
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, ComboBoxMatchers::getItemsString, comboBox -> ComboBoxMatchers.containsItemsInOrder(comboBox, items));
    }

    @Factory
    public static <T> Matcher<ComboBox> containsExactlyItemsInOrder(T ... items) {
        String descriptionText = "contains exactly items in order " + Arrays.toString(items);
        return GeneralMatchers.typeSafeMatcher(ComboBox.class, descriptionText, ComboBoxMatchers::getItemsString, comboBox -> ComboBoxMatchers.containsExactlyItemsInOrder(comboBox, items));
    }

    private static <T> boolean hasSelectedItem(ComboBox<?> comboBox, T selection) {
        return selection.equals(comboBox.getSelectionModel().getSelectedItem());
    }

    private static boolean containsItems(ComboBox<?> comboBox, Object ... items) {
        return comboBox.getItems().containsAll(Arrays.asList(items));
    }

    private static boolean containsExactlyItems(ComboBox<?> comboBox, Object ... items) {
        return comboBox.getItems().size() == items.length && comboBox.getItems().containsAll(Arrays.asList(items));
    }

    private static boolean containsItemsInOrder(ComboBox<?> comboBox, Object ... items) {
        int index = 0;
        while (!comboBox.getItems().get(index).equals(items[0])) {
            if (items.length >= comboBox.getItems().size() - index) {
                return false;
            }
            ++index;
        }
        return ComboBoxMatchers.matchSubSequenceInOrder(comboBox, index, items);
    }

    private static boolean containsExactlyItemsInOrder(ComboBox<?> comboBox, Object ... items) {
        return ComboBoxMatchers.matchSubSequenceInOrder(comboBox, 0, items);
    }

    private static boolean matchSubSequenceInOrder(ComboBox<?> comboBox, int startIndex, Object ... items) {
        int index = startIndex;
        for (Object item : items) {
            if (index >= comboBox.getItems().size() || !comboBox.getItems().get(index).equals(item)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static String getItemsString(ComboBox<?> comboBox) {
        StringBuilder items = new StringBuilder("[");
        for (int i = 0; i < comboBox.getItems().size(); ++i) {
            items.append(comboBox.getItems().get(i).toString());
            if (i >= comboBox.getItems().size() - 1) continue;
            items.append(", ");
        }
        items.append("]");
        return items.toString();
    }
}

