/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.base;

import java.util.Objects;
import javafx.scene.Node;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.api.FxAssert;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.query.NodeQuery;

public class NodeMatchers {
    private NodeMatchers() {
    }

    @Factory
    public static Matcher<Node> anything() {
        return GeneralMatchers.baseMatcher("anything", node -> true);
    }

    @Factory
    public static Matcher<Node> isNull() {
        return GeneralMatchers.baseMatcher("Node is null", Objects::isNull);
    }

    @Factory
    public static Matcher<Node> isNotNull() {
        return GeneralMatchers.baseMatcher("Node is not null", node -> node != null);
    }

    @Factory
    public static Matcher<Node> isVisible() {
        return GeneralMatchers.baseMatcher("Node is visible", Node::isVisible);
    }

    @Factory
    public static Matcher<Node> isInvisible() {
        return GeneralMatchers.baseMatcher("Node is invisible", node -> !node.isVisible());
    }

    @Factory
    public static Matcher<Node> isEnabled() {
        return GeneralMatchers.baseMatcher("Node is enabled", node -> !node.isDisabled());
    }

    @Factory
    public static Matcher<Node> isDisabled() {
        return GeneralMatchers.baseMatcher("Node is disabled", Node::isDisabled);
    }

    @Factory
    public static Matcher<Node> isFocused() {
        return GeneralMatchers.baseMatcher("Node has focus", Node::isFocused);
    }

    @Factory
    public static Matcher<Node> isNotFocused() {
        return GeneralMatchers.baseMatcher("Node does not have focus", node -> !node.isFocused());
    }

    @Factory
    public static Matcher<Node> hasChild(String query) {
        String descriptionText = "Node has child \"" + query + "\"";
        return GeneralMatchers.baseMatcher(descriptionText, node -> NodeMatchers.hasChild(node, query));
    }

    @Factory
    public static Matcher<Node> hasChildren(int amount, String query) {
        String descriptionText = "Node has " + amount + " children \"" + query + "\"";
        return GeneralMatchers.baseMatcher(descriptionText, node -> NodeMatchers.hasChildren(node, amount, query));
    }

    private static boolean hasChild(Node node, String query) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        NodeQuery nodeQuery = nodeFinder.from(node);
        return !nodeQuery.lookup(query).queryAll().isEmpty();
    }

    private static boolean hasChildren(Node node, int amount, String query) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        NodeQuery nodeQuery = nodeFinder.from(node);
        return nodeQuery.lookup(query).queryAll().size() == amount;
    }
}

