/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.base;

import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class GeneralMatchers {
    private GeneralMatchers() {
    }

    @Factory
    public static <T> Matcher<T> baseMatcher(final String descriptionText, final Predicate<T> predicate) {
        return new BaseMatcher<T>(){

            public void describeTo(Description description) {
                description.appendText(descriptionText);
            }

            public boolean matches(Object object) {
                return predicate.test(object);
            }

            public void describeMismatch(Object object, Description description) {
                description.appendText("was ").appendValue(object);
            }
        };
    }

    @Factory
    public static <S, T extends S> Matcher<S> typeSafeMatcher(final Class<T> expectedType, final String descriptionText, final Predicate<T> predicate) {
        return new TypeSafeMatcher<S>(expectedType){

            public void describeTo(Description description) {
                description.appendText(expectedType.getSimpleName());
                description.appendText(" ").appendText(descriptionText);
            }

            protected boolean matchesSafely(S object) {
                return predicate.test(object);
            }

            protected void describeMismatchSafely(S object, Description description) {
                description.appendText("was ").appendValue(object);
            }
        };
    }

    @Factory
    public static <S, T extends S> Matcher<S> typeSafeMatcher(final Class<T> expectedType, final String descriptionText, final Function<S, String> describeActual, final Predicate<T> predicate) {
        return new TypeSafeMatcher<S>(expectedType){

            public void describeTo(Description description) {
                description.appendText(expectedType.getSimpleName());
                description.appendText(" ").appendText(descriptionText);
            }

            protected boolean matchesSafely(S object) {
                return predicate.test(object);
            }

            protected void describeMismatchSafely(S object, Description description) {
                description.appendText("was ").appendText((String)describeActual.apply(object));
            }
        };
    }
}

