/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.vault;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Capability;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class VaultContainer<SELF extends VaultContainer<SELF>>
extends GenericContainer<SELF> {
    private static final int VAULT_PORT = 8200;
    private Map<String, List<String>> secretsMap = new HashMap<String, List<String>>();
    private int port = 8200;

    public VaultContainer() {
        this("vault:1.1.3");
    }

    public VaultContainer(String dockerImageName) {
        super(dockerImageName);
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/v1/sys/health").forStatusCode(200));
        this.withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.IPC_LOCK}));
        this.withEnv("VAULT_ADDR", "http://0.0.0.0:" + this.port);
        this.withExposedPorts(new Integer[]{this.port});
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.addSecrets();
    }

    private void addSecrets() {
        if (!this.secretsMap.isEmpty()) {
            try {
                this.execInContainer(this.buildExecCommand(this.secretsMap)).getStdout().contains("Success");
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Failed to add these secrets {} into Vault via exec command. Exception message: {}", this.secretsMap, (Object)e.getMessage());
            }
        }
    }

    private String[] buildExecCommand(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((path, secrets) -> {
            stringBuilder.append(" && vault kv put " + path);
            secrets.forEach(item -> stringBuilder.append(" " + item));
        });
        return new String[]{"/bin/sh", "-c", stringBuilder.toString().substring(4)};
    }

    public SELF withVaultToken(String token) {
        this.withEnv("VAULT_DEV_ROOT_TOKEN_ID", token);
        this.withEnv("VAULT_TOKEN", token);
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    @Deprecated
    public SELF withVaultPort(int port) {
        this.port = port;
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    public SELF withSecretInVault(String path, String firstSecret, String ... remainingSecrets) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(firstSecret);
        for (String secret : remainingSecrets) {
            list.add(secret);
        }
        if (this.secretsMap.containsKey(path)) {
            list.addAll(list);
        }
        this.secretsMap.putIfAbsent(path, list);
        return (SELF)((Object)((VaultContainer)this.self()));
    }
}

