/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.delegate;

import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.YugabyteDBYCQLContainer;
import org.testcontainers.containers.delegate.AbstractYCQLDelegate;
import org.testcontainers.ext.ScriptUtils;

public final class YugabyteDBYCQLDelegate
extends AbstractYCQLDelegate {
    private static final Logger log = LoggerFactory.getLogger(YugabyteDBYCQLDelegate.class);
    private static final String BIN_PATH = "/home/yugabyte/tserver/bin/ycqlsh";
    private final YugabyteDBYCQLContainer container;

    public void execute(Collection<String> statements, String scriptPath, boolean continueOnError, boolean ignoreFailedDrops) {
        String containerInterfaceIP = ((ContainerNetwork)((Map.Entry)this.container.getContainerInfo().getNetworkSettings().getNetworks().entrySet().stream().findFirst().get()).getValue()).getIpAddress();
        try {
            Container.ExecResult result = this.container.execInContainer(new String[]{BIN_PATH, containerInterfaceIP, "-u", this.container.getUsername(), "-p", this.container.getPassword(), "-k", this.container.getKeyspace(), "-e", StringUtils.join(statements, (String)";")});
            if (result.getExitCode() != 0) {
                throw new RuntimeException(result.getStderr());
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new ScriptUtils.UncategorizedScriptException(e.getMessage(), e);
        }
    }

    public YugabyteDBYCQLDelegate(YugabyteDBYCQLContainer container) {
        this.container = container;
    }
}

