/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.trino;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.utility.DockerImageName;

public class TrinoContainer
extends JdbcDatabaseContainer<TrinoContainer> {
    static final String NAME = "trino";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"trinodb/trino");
    static final String IMAGE = "trinodb/trino";
    @VisibleForTesting
    static final String DEFAULT_TAG = "352";
    private static final int TRINO_PORT = 8080;
    private String username = "test";
    private String catalog = null;

    public TrinoContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public TrinoContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(8080);
    }

    @Deprecated
    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return super.getLivenessCheckPorts();
    }

    public String getDriverClassName() {
        return "io.trino.jdbc.TrinoDriver";
    }

    public String getJdbcUrl() {
        return String.format("jdbc:trino://%s:%s/%s", this.getHost(), this.getMappedPort(8080), Strings.nullToEmpty((String)this.catalog));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return "";
    }

    public String getDatabaseName() {
        return this.catalog;
    }

    public String getTestQueryString() {
        return "SELECT count(*) FROM tpch.tiny.nation";
    }

    public TrinoContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public TrinoContainer withDatabaseName(String dbName) {
        this.catalog = dbName;
        return this;
    }

    public Connection createConnection() throws SQLException, JdbcDatabaseContainer.NoDriverFoundException {
        return this.createConnection("");
    }
}

