/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.jython;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyStringMap;
import org.testcontainers.shaded.freemarker.ext.beans.BeansWrapper;
import org.testcontainers.shaded.freemarker.ext.beans.DateModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonHashModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonNumberModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonSequenceModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonVersionAdapter;
import org.testcontainers.shaded.freemarker.ext.jython.JythonVersionAdapterHolder;
import org.testcontainers.shaded.freemarker.ext.jython.JythonWrapper;
import org.testcontainers.shaded.freemarker.ext.util.ModelCache;
import org.testcontainers.shaded.freemarker.template.TemplateModel;

class JythonModelCache
extends ModelCache {
    private final JythonWrapper wrapper;

    JythonModelCache(JythonWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected boolean isCacheable(Object object) {
        return true;
    }

    @Override
    protected TemplateModel create(Object obj) {
        boolean asHash = false;
        boolean asSequence = false;
        JythonVersionAdapter versionAdapter = JythonVersionAdapterHolder.INSTANCE;
        if (versionAdapter.isPyInstance(obj)) {
            Object jobj = versionAdapter.pyInstanceToJava(obj);
            if (jobj instanceof TemplateModel) {
                return (TemplateModel)jobj;
            }
            if (jobj instanceof Map) {
                asHash = true;
            }
            if (jobj instanceof Date) {
                return new DateModel((Date)jobj, BeansWrapper.getDefaultInstance());
            }
            if (jobj instanceof Collection) {
                asSequence = true;
                if (!(jobj instanceof List)) {
                    obj = new ArrayList((Collection)jobj);
                }
            }
        }
        if (!(obj instanceof PyObject)) {
            obj = Py.java2py((Object)obj);
        }
        if (asHash || obj instanceof PyDictionary || obj instanceof PyStringMap) {
            return JythonHashModel.FACTORY.create(obj, this.wrapper);
        }
        if (asSequence || obj instanceof PySequence) {
            return JythonSequenceModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyInteger || obj instanceof PyLong || obj instanceof PyFloat) {
            return JythonNumberModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyNone) {
            return null;
        }
        return JythonModel.FACTORY.create(obj, this.wrapper);
    }
}

