/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.testcontainers.shaded.freemarker.core.TemplateMarkupOutputModel;
import org.testcontainers.shaded.freemarker.core._DelayedFTLTypeDescription;
import org.testcontainers.shaded.freemarker.core._DelayedOrdinal;
import org.testcontainers.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.testcontainers.shaded.freemarker.core._TemplateModelException;
import org.testcontainers.shaded.freemarker.ext.beans.BeansWrapper;
import org.testcontainers.shaded.freemarker.ext.beans._MethodUtil;
import org.testcontainers.shaded.freemarker.template.ObjectWrapperAndUnwrapper;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.utility.ClassUtil;

class SimpleMethod {
    static final String MARKUP_OUTPUT_TO_STRING_TIP = "A markup output value can be converted to markup string like value?markup_string. But consider if the Java method whose argument it will be can handle markup strings properly.";
    private final Member member;
    private final Class[] argTypes;

    protected SimpleMethod(Member member, Class[] argTypes) {
        this.member = member;
        this.argTypes = argTypes;
    }

    Object[] unwrapArguments(List arguments, BeansWrapper wrapper) throws TemplateModelException {
        if (arguments == null) {
            arguments = Collections.EMPTY_LIST;
        }
        boolean isVarArg = _MethodUtil.isVarargs(this.member);
        int typesLen = this.argTypes.length;
        if (isVarArg) {
            if (typesLen - 1 > arguments.size()) {
                throw new _TemplateModelException(_MethodUtil.invocationErrorMessageStart(this.member), " takes at least ", typesLen - 1, typesLen - 1 == 1 ? " argument" : " arguments", ", but ", arguments.size(), " was given.");
            }
        } else if (typesLen != arguments.size()) {
            throw new _TemplateModelException(_MethodUtil.invocationErrorMessageStart(this.member), " takes ", typesLen, typesLen == 1 ? " argument" : " arguments", ", but ", arguments.size(), " was given.");
        }
        Object[] args = this.unwrapArguments(arguments, this.argTypes, isVarArg, wrapper);
        return args;
    }

    private Object[] unwrapArguments(List args, Class[] argTypes, boolean isVarargs, BeansWrapper w) throws TemplateModelException {
        if (args == null) {
            return null;
        }
        int typesLen = argTypes.length;
        int argsLen = args.size();
        Object[] unwrappedArgs = new Object[typesLen];
        Iterator it = args.iterator();
        int normalArgCnt = isVarargs ? typesLen - 1 : typesLen;
        int argIdx = 0;
        while (argIdx < normalArgCnt) {
            Class argType = argTypes[argIdx];
            TemplateModel argVal = (TemplateModel)it.next();
            Object unwrappedArgVal = w.tryUnwrapTo(argVal, argType);
            if (unwrappedArgVal == ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) {
                throw this.createArgumentTypeMismarchException(argIdx, argVal, argType);
            }
            if (unwrappedArgVal == null && argType.isPrimitive()) {
                throw this.createNullToPrimitiveArgumentException(argIdx, argType);
            }
            unwrappedArgs[argIdx++] = unwrappedArgVal;
        }
        if (isVarargs) {
            Class varargType = argTypes[typesLen - 1];
            Class<?> varargItemType = varargType.getComponentType();
            if (!it.hasNext()) {
                unwrappedArgs[argIdx++] = Array.newInstance(varargItemType, 0);
            } else {
                Object unwrappedArgVal;
                TemplateModel argVal = (TemplateModel)it.next();
                if (argsLen - argIdx == 1 && (unwrappedArgVal = w.tryUnwrapTo(argVal, varargType)) != ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) {
                    unwrappedArgs[argIdx++] = unwrappedArgVal;
                } else {
                    int varargArrayLen = argsLen - argIdx;
                    Object varargArray = Array.newInstance(varargItemType, varargArrayLen);
                    for (int varargIdx = 0; varargIdx < varargArrayLen; ++varargIdx) {
                        TemplateModel varargVal = varargIdx == 0 ? argVal : it.next();
                        Object unwrappedVarargVal = w.tryUnwrapTo(varargVal, varargItemType);
                        if (unwrappedVarargVal == ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) {
                            throw this.createArgumentTypeMismarchException(argIdx + varargIdx, varargVal, varargItemType);
                        }
                        if (unwrappedVarargVal == null && varargItemType.isPrimitive()) {
                            throw this.createNullToPrimitiveArgumentException(argIdx + varargIdx, varargItemType);
                        }
                        Array.set(varargArray, varargIdx, unwrappedVarargVal);
                    }
                    unwrappedArgs[argIdx++] = varargArray;
                }
            }
        }
        return unwrappedArgs;
    }

    private TemplateModelException createArgumentTypeMismarchException(int argIdx, TemplateModel argVal, Class targetType) {
        _ErrorDescriptionBuilder desc = new _ErrorDescriptionBuilder(_MethodUtil.invocationErrorMessageStart(this.member), " couldn't be called: Can't convert the ", new _DelayedOrdinal(argIdx + 1), " argument's value to the target Java type, ", ClassUtil.getShortClassName(targetType), ". The type of the actual value was: ", new _DelayedFTLTypeDescription(argVal));
        if (argVal instanceof TemplateMarkupOutputModel && targetType.isAssignableFrom(String.class)) {
            desc.tip(MARKUP_OUTPUT_TO_STRING_TIP);
        }
        return new _TemplateModelException(desc);
    }

    private TemplateModelException createNullToPrimitiveArgumentException(int argIdx, Class targetType) {
        return new _TemplateModelException(_MethodUtil.invocationErrorMessageStart(this.member), " couldn't be called: The value of the ", new _DelayedOrdinal(argIdx + 1), " argument was null, but the target Java parameter type (", ClassUtil.getShortClassName(targetType), ") is primitive and so can't store null.");
    }

    protected Member getMember() {
        return this.member;
    }
}

