/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.mysql;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.Set;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.mysql.MySQLContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;

public class MySQLR2DBCDatabaseContainer
implements R2DBCDatabaseContainer {
    private final MySQLContainer container;

    public MySQLR2DBCDatabaseContainer(MySQLContainer container) {
        this.container = container;
    }

    public static ConnectionFactoryOptions getOptions(MySQLContainer container) {
        ConnectionFactoryOptions options = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.DRIVER, (Object)"mysql").build();
        return new MySQLR2DBCDatabaseContainer(container).configure(options);
    }

    public ConnectionFactoryOptions configure(ConnectionFactoryOptions options) {
        return options.mutate().option(ConnectionFactoryOptions.HOST, (Object)this.container.getHost()).option(ConnectionFactoryOptions.PORT, (Object)this.container.getMappedPort(MySQLContainer.MYSQL_PORT)).option(ConnectionFactoryOptions.DATABASE, (Object)this.container.getDatabaseName()).option(ConnectionFactoryOptions.USER, (Object)this.container.getUsername()).option(ConnectionFactoryOptions.PASSWORD, (Object)this.container.getPassword()).build();
    }

    public Set<Startable> getDependencies() {
        return this.container.getDependencies();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void close() {
        this.container.close();
    }
}

