/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.mariadb;

import java.util.Set;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.DockerImageName;

public class MariaDBContainer
extends JdbcDatabaseContainer<MariaDBContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mariadb");
    public static final String NAME = "mariadb";
    static final String DEFAULT_USER = "test";
    static final String DEFAULT_PASSWORD = "test";
    static final Integer MARIADB_PORT = 3306;
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";
    private static final String MARIADB_ROOT_USER = "root";
    private static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";

    public MariaDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public MariaDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(MARIADB_PORT);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Sets.newHashSet((Object[])new Integer[]{MARIADB_PORT});
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, "/etc/mysql/conf.d", null, 16877);
        this.addEnv("MYSQL_DATABASE", this.databaseName);
        if (!MARIADB_ROOT_USER.equalsIgnoreCase(this.username)) {
            this.addEnv("MYSQL_USER", this.username);
        }
        if (this.password != null && !this.password.isEmpty()) {
            this.addEnv("MYSQL_PASSWORD", this.password);
            this.addEnv("MYSQL_ROOT_PASSWORD", this.password);
        } else if (MARIADB_ROOT_USER.equalsIgnoreCase(this.username)) {
            this.addEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes");
        } else {
            throw new ContainerLaunchException("Empty password can be used only with the root user");
        }
        this.setStartupAttempts(3);
    }

    public String getDriverClassName() {
        return "org.mariadb.jdbc.Driver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:mariadb://" + this.getHost() + ":" + this.getMappedPort(MARIADB_PORT) + "/" + this.databaseName + additionalUrlParams;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public MariaDBContainer withConfigurationOverride(String s) {
        this.parameters.put(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, s);
        return (MariaDBContainer)this.self();
    }

    public MariaDBContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (MariaDBContainer)this.self();
    }

    public MariaDBContainer withUsername(String username) {
        this.username = username;
        return (MariaDBContainer)this.self();
    }

    public MariaDBContainer withPassword(String password) {
        this.password = password;
        return (MariaDBContainer)this.self();
    }
}

