/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.cratedb;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class CrateDBContainer
extends JdbcDatabaseContainer<CrateDBContainer> {
    static final String NAME = "cratedb";
    static final String IMAGE = "crate";
    static final String DEFAULT_TAG = "5.3.1";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"crate");
    static final Integer CRATEDB_PG_PORT = 5432;
    static final Integer CRATEDB_HTTP_PORT = 4200;
    private String databaseName = "crate";
    private String username = "crate";
    private String password = "crate";

    public CrateDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CrateDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withCommand("crate -C discovery.type=single-node");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/").forPort(CRATEDB_HTTP_PORT.intValue()).forStatusCode(200));
        this.addExposedPort(CRATEDB_PG_PORT);
        this.addExposedPort(CRATEDB_HTTP_PORT);
    }

    @Deprecated
    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return super.getLivenessCheckPorts();
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(CRATEDB_PG_PORT) + "/" + this.databaseName + additionalUrlParams;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public CrateDBContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (CrateDBContainer)this.self();
    }

    public CrateDBContainer withUsername(String username) {
        this.username = username;
        return (CrateDBContainer)this.self();
    }

    public CrateDBContainer withPassword(String password) {
        this.password = password;
        return (CrateDBContainer)this.self();
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }
}

