/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.Unit;
import org.testcontainers.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.testcontainers.shaded.okhttp3.Headers;
import org.testcontainers.shaded.okhttp3.internal._UtilJvmKt;
import org.testcontainers.shaded.okhttp3.internal.concurrent.Lockable;
import org.testcontainers.shaded.okhttp3.internal.http2.ErrorCode;
import org.testcontainers.shaded.okhttp3.internal.http2.Header;
import org.testcontainers.shaded.okhttp3.internal.http2.Http2Connection;
import org.testcontainers.shaded.okhttp3.internal.http2.StreamResetException;
import org.testcontainers.shaded.okhttp3.internal.http2.flowcontrol.WindowCounter;
import org.testcontainers.shaded.okio.AsyncTimeout;
import org.testcontainers.shaded.okio.Buffer;
import org.testcontainers.shaded.okio.BufferedSource;
import org.testcontainers.shaded.okio.Sink;
import org.testcontainers.shaded.okio.Socket;
import org.testcontainers.shaded.okio.Source;
import org.testcontainers.shaded.okio.Timeout;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 b2\u00020\u00012\u00020\u0002:\u0004`abcB3\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010A\u001a\u00020\u000b2\b\b\u0002\u0010B\u001a\u00020\bJ\b\u0010C\u001a\u0004\u0018\u00010\u000bJ$\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010I\u001a\u00020\bJ\u000e\u0010J\u001a\u00020E2\u0006\u0010K\u001a\u00020\u000bJ\u0006\u0010+\u001a\u00020LJ\u0006\u0010/\u001a\u00020LJ\u0018\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u0002022\b\u00107\u001a\u0004\u0018\u000108J\b\u0010O\u001a\u00020EH\u0016J\u000e\u0010P\u001a\u00020E2\u0006\u00101\u001a\u000202J\u001a\u0010Q\u001a\u00020\b2\u0006\u00101\u001a\u0002022\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0016\u0010R\u001a\u00020E2\u0006\u0010#\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0004J\u0016\u0010U\u001a\u00020E2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010V\u001a\u00020E2\u0006\u00101\u001a\u000202J\b\u0010W\u001a\u00020\bH\u0002J\r\u0010X\u001a\u00020EH\u0000\u00a2\u0006\u0002\bYJ\u000e\u0010Z\u001a\u00020E2\u0006\u0010[\u001a\u00020\u0017J\r\u0010\\\u001a\u00020EH\u0000\u00a2\u0006\u0002\b]J\r\u0010^\u001a\u00020EH\u0000\u00a2\u0006\u0002\b_R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\u00060$R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0018\u0010'\u001a\u00060(R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0018\u0010+\u001a\u00060,R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u00060,R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u001e\u00101\u001a\u0004\u0018\u0001028@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u000108X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010>R\u0011\u0010@\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010>\u00a8\u0006d"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream;", "Lorg/testcontainers/shaded/okhttp3/internal/concurrent/Lockable;", "Lorg/testcontainers/shaded/okio/Socket;", "id", "", "connection", "Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Connection;", "outFinished", "", "inFinished", "headers", "Lorg/testcontainers/shaded/okhttp3/Headers;", "<init>", "(ILokhttp3/internal/http2/Http2Connection;ZZLokhttp3/Headers;)V", "getId", "()I", "getConnection", "()Lokhttp3/internal/http2/Http2Connection;", "readBytes", "Lorg/testcontainers/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "getReadBytes", "()Lokhttp3/internal/http2/flowcontrol/WindowCounter;", "value", "", "writeBytesTotal", "getWriteBytesTotal", "()J", "setWriteBytesTotal$okhttp", "(J)V", "writeBytesMaximum", "getWriteBytesMaximum", "setWriteBytesMaximum$okhttp", "headersQueue", "Ljava/util/ArrayDeque;", "hasResponseHeaders", "source", "Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "getSource", "()Lokhttp3/internal/http2/Http2Stream$FramingSource;", "sink", "Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "getSink", "()Lokhttp3/internal/http2/Http2Stream$FramingSink;", "readTimeout", "Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "getReadTimeout$okhttp", "()Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "writeTimeout", "getWriteTimeout$okhttp", "errorCode", "Lorg/testcontainers/shaded/okhttp3/internal/http2/ErrorCode;", "getErrorCode$okhttp", "()Lokhttp3/internal/http2/ErrorCode;", "setErrorCode$okhttp", "(Lokhttp3/internal/http2/ErrorCode;)V", "errorException", "Ljava/io/IOException;", "getErrorException$okhttp", "()Ljava/io/IOException;", "setErrorException$okhttp", "(Ljava/io/IOException;)V", "isOpen", "()Z", "isLocallyInitiated", "isSourceComplete", "takeHeaders", "callerIsIdle", "peekTrailers", "writeHeaders", "", "responseHeaders", "", "Lorg/testcontainers/shaded/okhttp3/internal/http2/Header;", "flushHeaders", "enqueueTrailers", "trailers", "Lorg/testcontainers/shaded/okio/Timeout;", "close", "rstStatusCode", "cancel", "closeLater", "closeInternal", "receiveData", "Lorg/testcontainers/shaded/okio/BufferedSource;", "length", "receiveHeaders", "receiveRstStream", "doReadTimeout", "cancelStreamIfNecessary", "cancelStreamIfNecessary$okhttp", "addBytesToWriteWindow", "delta", "checkOutNotClosed", "checkOutNotClosed$okhttp", "waitForIo", "waitForIo$okhttp", "FramingSource", "FramingSink", "Companion", "StreamTimeout", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n1#2:744\n63#3:745\n63#3:746\n63#3:747\n63#3:748\n63#3:749\n49#3,4:750\n63#3:754\n38#3:755\n63#3:756\n63#3:757\n49#3,4:758\n63#3:762\n38#3:763\n49#3,4:764\n49#3,4:768\n63#3:772\n38#3:773\n63#3:774\n38#3:775\n49#3,4:776\n63#3:780\n38#3:781\n34#3:782\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n*L\n89#1:745\n114#1:746\n136#1:747\n149#1:748\n175#1:749\n200#1:750,4\n203#1:754\n207#1:755\n214#1:756\n227#1:757\n272#1:758,4\n274#1:762\n280#1:763\n294#1:764,4\n304#1:768,4\n307#1:772\n321#1:773\n329#1:774\n332#1:775\n543#1:776,4\n547#1:780\n693#1:781\n713#1:782\n*E\n"})
public final class Http2Stream
implements Lockable,
Socket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final Http2Connection connection;
    @NotNull
    private final WindowCounter readBytes;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final ArrayDeque<Headers> headersQueue;
    private boolean hasResponseHeaders;
    @NotNull
    private final FramingSource source;
    @NotNull
    private final FramingSink sink;
    @NotNull
    private final StreamTimeout readTimeout;
    @NotNull
    private final StreamTimeout writeTimeout;
    @Nullable
    private ErrorCode errorCode;
    @Nullable
    private IOException errorException;
    public static final long EMIT_BUFFER_SIZE = 16384L;

    public Http2Stream(int id, @NotNull Http2Connection connection, boolean outFinished, boolean inFinished, @Nullable Headers headers) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.id = id;
        this.connection = connection;
        this.readBytes = new WindowCounter(this.id);
        this.writeBytesMaximum = this.connection.getPeerSettings().getInitialWindowSize();
        this.headersQueue = new ArrayDeque();
        this.source = new FramingSource(this.connection.getOkHttpSettings().getInitialWindowSize(), inFinished);
        this.sink = new FramingSink(this, outFinished);
        this.readTimeout = new StreamTimeout();
        this.writeTimeout = new StreamTimeout();
        if (headers != null) {
            if (!(!this.isLocallyInitiated())) {
                boolean $i$a$-check-Http2Stream$32 = false;
                String $i$a$-check-Http2Stream$32 = "locally-initiated streams shouldn't have headers yet";
                throw new IllegalStateException($i$a$-check-Http2Stream$32.toString());
            }
            ((Collection)this.headersQueue).add(headers);
        } else if (!this.isLocallyInitiated()) {
            boolean bl = false;
            String string = "remotely-initiated streams should have headers";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final Http2Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final WindowCounter getReadBytes() {
        return this.readBytes;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final void setWriteBytesTotal$okhttp(long l) {
        this.writeBytesTotal = l;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final void setWriteBytesMaximum$okhttp(long l) {
        this.writeBytesMaximum = l;
    }

    @Override
    @NotNull
    public FramingSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public FramingSink getSink() {
        return this.sink;
    }

    @NotNull
    public final StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    @NotNull
    public final StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ErrorCode getErrorCode$okhttp() {
        ErrorCode errorCode;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            errorCode = this.errorCode;
        }
        return errorCode;
    }

    public final void setErrorCode$okhttp(@Nullable ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Nullable
    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final void setErrorException$okhttp(@Nullable IOException iOException) {
        this.errorException = iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.getErrorCode$okhttp() == null) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (!this.getSource().getFinished$okhttp() && !this.getSource().getClosed$okhttp() || !this.getSink().getFinished() && !this.getSink().getClosed() || !this.hasResponseHeaders) break block6;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public final boolean isLocallyInitiated() {
        boolean streamIsClient = (this.id & 1) == 1;
        return this.connection.getClient$okhttp() == streamIsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSourceComplete() {
        boolean bl;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl2 = false;
            bl = this.getSource().getFinished$okhttp() && this.getSource().getReadBuffer().exhausted();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Headers takeHeaders(boolean callerIsIdle) throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            Throwable throwable;
            block11: {
                boolean bl = false;
                while (this.headersQueue.isEmpty() && this.getErrorCode$okhttp() == null) {
                    boolean doReadTimeout;
                    boolean bl2 = doReadTimeout = callerIsIdle || this.doReadTimeout();
                    if (doReadTimeout) {
                        this.readTimeout.enter();
                    }
                    try {
                        this.waitForIo$okhttp();
                    }
                    finally {
                        if (!doReadTimeout) continue;
                        this.readTimeout.exitAndThrowIfTimedOut();
                    }
                }
                if (!(!((Collection)this.headersQueue).isEmpty())) break block11;
                Headers headers = this.headersQueue.removeFirst();
                Intrinsics.checkNotNullExpressionValue(headers, "removeFirst(...)");
                Headers headers2 = headers;
                return headers2;
            }
            IOException iOException = this.errorException;
            if (iOException != null) {
                throwable = iOException;
            } else {
                ErrorCode errorCode = this.getErrorCode$okhttp();
                Intrinsics.checkNotNull((Object)errorCode);
                throwable = new StreamResetException(errorCode);
            }
            throw throwable;
        }
    }

    public static /* synthetic */ Headers takeHeaders$default(Http2Stream http2Stream, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return http2Stream.takeHeaders(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Headers peekTrailers() throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block8: {
                boolean bl = false;
                if (!this.getSource().getFinished$okhttp() || !this.getSource().getReceiveBuffer().exhausted() || !this.getSource().getReadBuffer().exhausted()) break block8;
                Headers headers = this.getSource().getTrailers();
                if (headers == null) {
                    headers = Headers.EMPTY;
                }
                Headers headers2 = headers;
                return headers2;
            }
            if (this.getErrorCode$okhttp() != null) {
                Throwable throwable;
                IOException iOException = this.errorException;
                if (iOException != null) {
                    throwable = iOException;
                } else {
                    ErrorCode errorCode = this.getErrorCode$okhttp();
                    Intrinsics.checkNotNull((Object)errorCode);
                    throwable = new StreamResetException(errorCode);
                }
                throw throwable;
            }
            Headers headers = null;
            return headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeHeaders(@NotNull List<Header> responseHeaders, boolean outFinished, boolean flushHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(responseHeaders, "responseHeaders");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean flushHeaders2 = false;
        flushHeaders2 = flushHeaders;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.hasResponseHeaders = true;
            if (outFinished) {
                this.getSink().setFinished(true);
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!flushHeaders2) {
            $this$withLock$iv = this;
            $i$f$withLock = false;
            lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                flushHeaders2 = this.connection.getWriteBytesTotal() >= this.connection.getWriteBytesMaximum();
                Unit unit = Unit.INSTANCE;
            }
        }
        this.connection.writeHeaders$okhttp(this.id, outFinished, responseHeaders);
        if (flushHeaders2) {
            this.connection.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueTrailers(@NotNull Headers trailers) {
        Intrinsics.checkNotNullParameter(trailers, "trailers");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!(!this.getSink().getFinished())) {
                boolean $i$a$-check-Http2Stream$enqueueTrailers$1$22 = false;
                String $i$a$-check-Http2Stream$enqueueTrailers$1$22 = "already finished";
                throw new IllegalStateException($i$a$-check-Http2Stream$enqueueTrailers$1$22.toString());
            }
            if (!(trailers.size() != 0)) {
                boolean bl2 = false;
                String string = "trailers.size() == 0";
                throw new IllegalArgumentException(string.toString());
            }
            this.getSink().setTrailers(trailers);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    @NotNull
    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public final void close(@NotNull ErrorCode rstStatusCode, @Nullable IOException errorException) throws IOException {
        Intrinsics.checkNotNullParameter((Object)rstStatusCode, "rstStatusCode");
        if (!this.closeInternal(rstStatusCode, errorException)) {
            return;
        }
        this.connection.writeSynReset$okhttp(this.id, rstStatusCode);
    }

    @Override
    public void cancel() {
        this.closeLater(ErrorCode.CANCEL);
    }

    public final void closeLater(@NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean closeInternal(ErrorCode errorCode, IOException errorException) {
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block7: {
                block6: {
                    boolean bl = false;
                    if (this.getErrorCode$okhttp() == null) break block6;
                    boolean bl2 = false;
                    return bl2;
                }
                this.errorCode = errorCode;
                this.errorException = errorException;
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                if (!this.getSource().getFinished$okhttp() || !this.getSink().getFinished()) break block7;
                boolean bl = false;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        this.connection.removeStream$okhttp(this.id);
        return true;
    }

    public final void receiveData(@NotNull BufferedSource source2, int length) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        this.getSource().receive$okhttp(source2, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveHeaders(@NotNull Headers headers, boolean inFinished) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean open = false;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!this.hasResponseHeaders || headers.get(":status") != null || headers.get(":method") != null) {
                this.hasResponseHeaders = true;
                ((Collection)this.headersQueue).add(headers);
            } else {
                this.getSource().setTrailers(headers);
            }
            if (inFinished) {
                this.getSource().setFinished$okhttp(true);
            }
            open = this.isOpen();
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        if (!open) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveRstStream(@NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.getErrorCode$okhttp() == null) {
                this.errorCode = errorCode;
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean doReadTimeout() {
        return !this.connection.getClient$okhttp() || this.getSink().getClosed() || this.getSink().getFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelStreamIfNecessary$okhttp() throws IOException {
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean open = false;
        boolean cancel = false;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            cancel = !this.getSource().getFinished$okhttp() && this.getSource().getClosed$okhttp() && (this.getSink().getFinished() || this.getSink().getClosed());
            open = this.isOpen();
            Unit unit = Unit.INSTANCE;
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL, null);
        } else if (!open) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    public final void addBytesToWriteWindow(long delta) {
        this.writeBytesMaximum += delta;
        if (delta > 0L) {
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() throws IOException {
        if (this.getSink().getClosed()) {
            throw new IOException("stream closed");
        }
        if (this.getSink().getFinished()) {
            throw new IOException("stream finished");
        }
        if (this.getErrorCode$okhttp() != null) {
            Throwable throwable;
            IOException iOException = this.errorException;
            if (iOException != null) {
                throwable = iOException;
            } else {
                ErrorCode errorCode = this.getErrorCode$okhttp();
                Intrinsics.checkNotNull((Object)errorCode);
                throwable = new StreamResetException(errorCode);
            }
            throw throwable;
        }
    }

    public final void waitForIo$okhttp() throws InterruptedIOException {
        try {
            Lockable $this$wait$iv = this;
            boolean $i$f$wait = false;
            Intrinsics.checkNotNull($this$wait$iv, "null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$wait$iv).wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$Companion;", "", "<init>", "()V", "EMIT_BUFFER_SIZE", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\t\u00a8\u0006 "}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "Lorg/testcontainers/shaded/okio/Sink;", "finished", "", "<init>", "(Lokhttp3/internal/http2/Http2Stream;Z)V", "getFinished", "()Z", "setFinished", "(Z)V", "sendBuffer", "Lorg/testcontainers/shaded/okio/Buffer;", "trailers", "Lorg/testcontainers/shaded/okhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "closed", "getClosed", "setClosed", "write", "", "source", "byteCount", "", "emitFrame", "outFinishedOnLastFrame", "flush", "timeout", "Lorg/testcontainers/shaded/okio/Timeout;", "close", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n49#2,4:744\n63#2:748\n49#2,4:749\n63#2:753\n49#2,4:754\n63#2:758\n63#2:759\n38#2:760\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n*L\n582#1:744,4\n598#1:748\n628#1:749,4\n630#1:753\n644#1:754,4\n647#1:758\n676#1:759\n678#1:760\n*E\n"})
    public final class FramingSink
    implements Sink {
        private boolean finished;
        @NotNull
        private final Buffer sendBuffer;
        @Nullable
        private Headers trailers;
        private boolean closed;
        final /* synthetic */ Http2Stream this$0;

        public FramingSink(Http2Stream this$0, boolean finished) {
            this.this$0 = this$0;
            this.finished = finished;
            this.sendBuffer = new Buffer();
        }

        public /* synthetic */ FramingSink(Http2Stream http2Stream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(http2Stream, bl);
        }

        public final boolean getFinished() {
            return this.finished;
        }

        public final void setFinished(boolean bl) {
            this.finished = bl;
        }

        @Nullable
        public final Headers getTrailers() {
            return this.trailers;
        }

        public final void setTrailers(@Nullable Headers headers) {
            this.trailers = headers;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            this.sendBuffer.write(source2, byteCount);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void emitFrame(boolean outFinishedOnLastFrame) throws IOException {
            void $this$withLock$iv;
            long toWrite = 0L;
            boolean outFinished = false;
            Lockable lockable = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var6_8 = $this$withLock$iv;
            synchronized (var6_8) {
                boolean bl = false;
                http2Stream.getWriteTimeout$okhttp().enter();
                try {
                    while (http2Stream.getWriteBytesTotal() >= http2Stream.getWriteBytesMaximum() && !this.finished && !this.closed && http2Stream.getErrorCode$okhttp() == null) {
                        http2Stream.waitForIo$okhttp();
                    }
                }
                finally {
                    http2Stream.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                http2Stream.checkOutNotClosed$okhttp();
                toWrite = Math.min(http2Stream.getWriteBytesMaximum() - http2Stream.getWriteBytesTotal(), this.sendBuffer.size());
                http2Stream.setWriteBytesTotal$okhttp(http2Stream.getWriteBytesTotal() + toWrite);
                outFinished = outFinishedOnLastFrame && toWrite == this.sendBuffer.size();
                Unit unit = Unit.INSTANCE;
            }
            this.this$0.getWriteTimeout$okhttp().enter();
            try {
                this.this$0.getConnection().writeData(this.this$0.getId(), outFinished, this.sendBuffer, toWrite);
            }
            finally {
                this.this$0.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void flush() throws IOException {
            void $this$withLock$iv;
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            $this$assertLockNotHeld$iv = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var4_5 = $this$withLock$iv;
            synchronized (var4_5) {
                boolean bl = false;
                http2Stream.checkOutNotClosed$okhttp();
                Unit unit = Unit.INSTANCE;
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                this.this$0.getConnection().flush();
            }
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.this$0.getWriteTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() throws IOException {
            void $this$withLock$iv;
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld22 = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            boolean outFinished = false;
            Lockable $i$f$assertLockNotHeld22 = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var5_11 = $this$withLock$iv;
            synchronized (var5_11) {
                boolean bl = false;
                if (this.closed) {
                    return;
                }
                outFinished = http2Stream.getErrorCode$okhttp() == null;
                Unit unit = Unit.INSTANCE;
            }
            if (!this.this$0.getSink().finished) {
                boolean hasData = this.sendBuffer.size() > 0L;
                boolean hasTrailers = this.trailers != null;
                if (hasTrailers) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Connection http2Connection = this.this$0.getConnection();
                    int n = this.this$0.getId();
                    Headers headers = this.trailers;
                    Intrinsics.checkNotNull(headers);
                    http2Connection.writeHeaders$okhttp(n, outFinished, _UtilJvmKt.toHeaderList(headers));
                } else if (hasData) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else if (outFinished) {
                    this.this$0.getConnection().writeData(this.this$0.getId(), true, null, 0L);
                }
            }
            Lockable hasData = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            $i$f$withLock = false;
            var5_11 = $this$withLock$iv;
            synchronized (var5_11) {
                boolean bl = false;
                this.closed = true;
                Lockable $this$notifyAll$iv = http2Stream2;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            this.this$0.getConnection().flush();
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u001d\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "Lorg/testcontainers/shaded/okio/Source;", "maxByteCount", "", "finished", "", "<init>", "(Lokhttp3/internal/http2/Http2Stream;JZ)V", "getFinished$okhttp", "()Z", "setFinished$okhttp", "(Z)V", "receiveBuffer", "Lorg/testcontainers/shaded/okio/Buffer;", "getReceiveBuffer", "()Lokio/Buffer;", "readBuffer", "getReadBuffer", "trailers", "Lorg/testcontainers/shaded/okhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "closed", "getClosed$okhttp", "setClosed$okhttp", "read", "sink", "byteCount", "updateConnectionFlowControl", "", "receive", "source", "Lorg/testcontainers/shaded/okio/BufferedSource;", "receive$okhttp", "timeout", "Lorg/testcontainers/shaded/okio/Timeout;", "close", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n1#2:744\n63#3:745\n49#3,4:746\n49#3,4:750\n63#3:754\n63#3:755\n38#3:756\n63#3:757\n38#3:758\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n*L\n390#1:745\n453#1:746,4\n467#1:750,4\n474#1:754\n500#1:755\n507#1:756\n528#1:757\n532#1:758\n*E\n"})
    public final class FramingSource
    implements Source {
        private final long maxByteCount;
        private boolean finished;
        @NotNull
        private final Buffer receiveBuffer;
        @NotNull
        private final Buffer readBuffer;
        @Nullable
        private Headers trailers;
        private boolean closed;

        public FramingSource(long maxByteCount, boolean finished) {
            this.maxByteCount = maxByteCount;
            this.finished = finished;
            this.receiveBuffer = new Buffer();
            this.readBuffer = new Buffer();
        }

        public final boolean getFinished$okhttp() {
            return this.finished;
        }

        public final void setFinished$okhttp(boolean bl) {
            this.finished = bl;
        }

        @NotNull
        public final Buffer getReceiveBuffer() {
            return this.receiveBuffer;
        }

        @NotNull
        public final Buffer getReadBuffer() {
            return this.readBuffer;
        }

        @Nullable
        public final Headers getTrailers() {
            return this.trailers;
        }

        public final void setTrailers(@Nullable Headers headers) {
            this.trailers = headers;
        }

        public final boolean getClosed$okhttp() {
            return this.closed;
        }

        public final void setClosed$okhttp(boolean bl) {
            this.closed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
            IOException errorExceptionToDeliver;
            long readBytesDelivered;
            boolean tryAgain;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean bl = false;
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            do {
                void $this$withLock$iv;
                tryAgain = false;
                readBytesDelivered = 0L;
                readBytesDelivered = -1L;
                errorExceptionToDeliver = null;
                Lockable lockable = Http2Stream.this;
                Http2Stream http2Stream = Http2Stream.this;
                boolean $i$f$withLock = false;
                void var10_10 = $this$withLock$iv;
                synchronized (var10_10) {
                    boolean bl = false;
                    boolean doReadTimeout = http2Stream.doReadTimeout();
                    if (doReadTimeout) {
                        http2Stream.getReadTimeout$okhttp().enter();
                    }
                    try {
                        IOException iOException;
                        if (http2Stream.getErrorCode$okhttp() != null && !this.finished && (iOException = http2Stream.getErrorException$okhttp()) == null) {
                            ErrorCode errorCode = http2Stream.getErrorCode$okhttp();
                            Intrinsics.checkNotNull((Object)errorCode);
                            iOException = errorExceptionToDeliver = (IOException)new StreamResetException(errorCode);
                        }
                        if (this.closed) {
                            throw new IOException("stream closed");
                        }
                        if (this.readBuffer.size() > 0L) {
                            readBytesDelivered = this.readBuffer.read(sink2, Math.min(byteCount, this.readBuffer.size()));
                            WindowCounter.update$default(http2Stream.getReadBytes(), readBytesDelivered, 0L, 2, null);
                            long unacknowledgedBytesRead = http2Stream.getReadBytes().getUnacknowledged();
                            if (errorExceptionToDeliver == null && unacknowledgedBytesRead >= (long)(http2Stream.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                                http2Stream.getConnection().writeWindowUpdateLater$okhttp(http2Stream.getId(), unacknowledgedBytesRead);
                                WindowCounter.update$default(http2Stream.getReadBytes(), 0L, unacknowledgedBytesRead, 1, null);
                            }
                        } else if (!this.finished && errorExceptionToDeliver == null) {
                            http2Stream.waitForIo$okhttp();
                            tryAgain = true;
                        }
                    }
                    finally {
                        if (doReadTimeout) {
                            http2Stream.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Http2Stream.this.getConnection().getFlowControlListener$okhttp().receivingStreamWindowChanged(Http2Stream.this.getId(), Http2Stream.this.getReadBytes(), this.readBuffer.size());
            } while (tryAgain);
            if (readBytesDelivered != -1L) {
                return readBytesDelivered;
            }
            if (errorExceptionToDeliver != null) {
                throw (Throwable)errorExceptionToDeliver;
            }
            return -1L;
        }

        private final void updateConnectionFlowControl(long read) {
            Lockable $this$assertLockNotHeld$iv = Http2Stream.this;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            Http2Stream.this.getConnection().updateConnectionFlowControl$okhttp(read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void receive$okhttp(@NotNull BufferedSource source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Lockable $this$assertLockNotHeld$iv = Http2Stream.this;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            long remainingByteCount = 0L;
            remainingByteCount = byteCount;
            while (remainingByteCount > 0L) {
                void $this$withLock$iv;
                boolean finished = false;
                boolean flowControlError = false;
                Lockable $this$withLock$iv2 = Http2Stream.this;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv2;
                synchronized (lockable) {
                    boolean bl = false;
                    finished = this.finished;
                    flowControlError = remainingByteCount + this.readBuffer.size() > this.maxByteCount;
                    Unit unit = Unit.INSTANCE;
                }
                if (flowControlError) {
                    source2.skip(remainingByteCount);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    source2.skip(remainingByteCount);
                    return;
                }
                long read = source2.read(this.receiveBuffer, remainingByteCount);
                if (read == -1L) {
                    throw new EOFException();
                }
                remainingByteCount -= read;
                lockable = Http2Stream.this;
                Http2Stream http2Stream = Http2Stream.this;
                boolean $i$f$withLock2 = false;
                void var12_15 = $this$withLock$iv;
                synchronized (var12_15) {
                    boolean bl = false;
                    if (this.closed) {
                        this.receiveBuffer.clear();
                    } else {
                        boolean wasEmpty = this.readBuffer.size() == 0L;
                        this.readBuffer.writeAll(this.receiveBuffer);
                        if (wasEmpty) {
                            Lockable $this$notifyAll$iv = http2Stream;
                            boolean $i$f$notifyAll = false;
                            Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            this.updateConnectionFlowControl(byteCount);
            Http2Stream.this.getConnection().getFlowControlListener$okhttp().receivingStreamWindowChanged(Http2Stream.this.getId(), Http2Stream.this.getReadBytes(), this.readBuffer.size());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Http2Stream.this.getReadTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() throws IOException {
            void $this$withLock$iv;
            long bytesDiscarded = 0L;
            Lockable lockable = Http2Stream.this;
            Http2Stream http2Stream = Http2Stream.this;
            boolean $i$f$withLock = false;
            void var4_5 = $this$withLock$iv;
            synchronized (var4_5) {
                boolean bl = false;
                this.closed = true;
                bytesDiscarded = this.readBuffer.size();
                this.readBuffer.clear();
                Lockable $this$notifyAll$iv = http2Stream;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            if (bytesDiscarded > 0L) {
                this.updateConnectionFlowControl(bytesDiscarded);
            }
            Http2Stream.this.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0014J\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lorg/testcontainers/shaded/okio/AsyncTimeout;", "<init>", "(Lokhttp3/internal/http2/Http2Stream;)V", "timedOut", "", "newTimeoutException", "Ljava/io/IOException;", "cause", "exitAndThrowIfTimedOut", "okhttp"})
    public final class StreamTimeout
    extends AsyncTimeout {
        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.getConnection().sendDegradedPingLater$okhttp();
        }

        @Override
        @NotNull
        protected IOException newTimeoutException(@Nullable IOException cause) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException $this$newTimeoutException_u24lambda_u240 = socketTimeoutException = new SocketTimeoutException("timeout");
            boolean bl = false;
            if (cause != null) {
                $this$newTimeoutException_u24lambda_u240.initCause(cause);
            }
            return socketTimeoutException;
        }

        public final void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }
}

