/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.cassandra;

import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.cassandra.CassandraDatabaseDelegate;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.delegate.DatabaseDelegate;

public class CassandraQueryWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(CassandraQueryWaitStrategy.class);
    private static final String SELECT_VERSION_QUERY = "SELECT release_version FROM system.local";
    private static final String TIMEOUT_ERROR = "Timed out waiting for Cassandra to be accessible for query execution";

    protected void waitUntilReady() {
        try {
            Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
                this.getRateLimiter().doWhenReady(() -> {
                    try (DatabaseDelegate databaseDelegate = this.getDatabaseDelegate();){
                        log.info("Checking connection is ready...");
                        ((CassandraDatabaseDelegate)databaseDelegate).execute(SELECT_VERSION_QUERY, "", 1, false, false, true);
                    }
                });
                return true;
            });
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException(TIMEOUT_ERROR);
        }
    }

    private DatabaseDelegate getDatabaseDelegate() {
        return new CassandraDatabaseDelegate((ContainerState)this.waitStrategyTarget);
    }
}

