/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.List;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.collections.ArrayDeque;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.testcontainers.shaded.okhttp3.Address;
import org.testcontainers.shaded.okhttp3.ConnectionSpec;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.Protocol;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.shaded.okhttp3.Route;
import org.testcontainers.shaded.okhttp3.internal._UtilJvmKt;
import org.testcontainers.shaded.okhttp3.internal.concurrent.Lockable;
import org.testcontainers.shaded.okhttp3.internal.concurrent.TaskRunner;
import org.testcontainers.shaded.okhttp3.internal.connection.ConnectPlan;
import org.testcontainers.shaded.okhttp3.internal.connection.RealCall;
import org.testcontainers.shaded.okhttp3.internal.connection.RealConnection;
import org.testcontainers.shaded.okhttp3.internal.connection.RealConnectionPool;
import org.testcontainers.shaded.okhttp3.internal.connection.ReusePlan;
import org.testcontainers.shaded.okhttp3.internal.connection.RouteDatabase;
import org.testcontainers.shaded.okhttp3.internal.connection.RoutePlanner;
import org.testcontainers.shaded.okhttp3.internal.connection.RouteSelector;
import org.testcontainers.shaded.okhttp3.internal.platform.Platform;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bq\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\b\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020$H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J-\u0010.\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010,2\u0010\b\u0002\u00100\u001a\n\u0012\u0004\u0012\u00020!\u0018\u000101H\u0000\u00a2\u0006\u0002\b2J'\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020!2\u0010\b\u0002\u00100\u001a\n\u0012\u0004\u0012\u00020!\u0018\u000101H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020\u00162\u0006\u00104\u001a\u00020!H\u0002J\u0012\u00107\u001a\u00020\r2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010!2\u0006\u0010;\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020>H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006?"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/connection/RealRoutePlanner;", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RoutePlanner;", "taskRunner", "Lorg/testcontainers/shaded/okhttp3/internal/concurrent/TaskRunner;", "connectionPool", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RealConnectionPool;", "readTimeoutMillis", "", "writeTimeoutMillis", "socketConnectTimeoutMillis", "socketReadTimeoutMillis", "pingIntervalMillis", "retryOnConnectionFailure", "", "fastFallback", "address", "Lorg/testcontainers/shaded/okhttp3/Address;", "routeDatabase", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RouteDatabase;", "call", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RealCall;", "request", "Lorg/testcontainers/shaded/okhttp3/Request;", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/internal/connection/RealConnectionPool;IIIIIZZLokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/internal/connection/RealCall;Lokhttp3/Request;)V", "getAddress", "()Lokhttp3/Address;", "doExtensiveHealthChecks", "routeSelection", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RouteSelector;", "nextRouteToTry", "Lorg/testcontainers/shaded/okhttp3/Route;", "deferredPlans", "Lorg/testcontainers/shaded/kotlin/collections/ArrayDeque;", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RoutePlanner$Plan;", "getDeferredPlans", "()Lkotlin/collections/ArrayDeque;", "isCanceled", "plan", "planReuseCallConnection", "Lorg/testcontainers/shaded/okhttp3/internal/connection/ReusePlan;", "planConnect", "Lorg/testcontainers/shaded/okhttp3/internal/connection/ConnectPlan;", "planConnect$okhttp", "planReusePooledConnection", "planToReplace", "routes", "", "planReusePooledConnection$okhttp", "planConnectToRoute", "route", "planConnectToRoute$okhttp", "createTunnelRequest", "hasNext", "failedConnection", "Lorg/testcontainers/shaded/okhttp3/internal/connection/RealConnection;", "retryRoute", "connection", "sameHostAndPort", "url", "Lorg/testcontainers/shaded/okhttp3/HttpUrl;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealRoutePlanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealRoutePlanner.kt\nokhttp3/internal/connection/RealRoutePlanner\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,348:1\n63#2:349\n63#2:350\n*S KotlinDebug\n*F\n+ 1 RealRoutePlanner.kt\nokhttp3/internal/connection/RealRoutePlanner\n*L\n100#1:349\n327#1:350\n*E\n"})
public final class RealRoutePlanner
implements RoutePlanner {
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final RealConnectionPool connectionPool;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int socketConnectTimeoutMillis;
    private final int socketReadTimeoutMillis;
    private final int pingIntervalMillis;
    private final boolean retryOnConnectionFailure;
    private final boolean fastFallback;
    @NotNull
    private final Address address;
    @NotNull
    private final RouteDatabase routeDatabase;
    @NotNull
    private final RealCall call;
    private final boolean doExtensiveHealthChecks;
    @Nullable
    private RouteSelector.Selection routeSelection;
    @Nullable
    private RouteSelector routeSelector;
    @Nullable
    private Route nextRouteToTry;
    @NotNull
    private final ArrayDeque<RoutePlanner.Plan> deferredPlans;

    public RealRoutePlanner(@NotNull TaskRunner taskRunner, @NotNull RealConnectionPool connectionPool, int readTimeoutMillis, int writeTimeoutMillis, int socketConnectTimeoutMillis, int socketReadTimeoutMillis, int pingIntervalMillis, boolean retryOnConnectionFailure, boolean fastFallback, @NotNull Address address, @NotNull RouteDatabase routeDatabase, @NotNull RealCall call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(routeDatabase, "routeDatabase");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(request, "request");
        this.taskRunner = taskRunner;
        this.connectionPool = connectionPool;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.socketConnectTimeoutMillis = socketConnectTimeoutMillis;
        this.socketReadTimeoutMillis = socketReadTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.fastFallback = fastFallback;
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.call = call;
        this.doExtensiveHealthChecks = !Intrinsics.areEqual(request.method(), "GET");
        this.deferredPlans = new ArrayDeque();
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    @Override
    @NotNull
    public ArrayDeque<RoutePlanner.Plan> getDeferredPlans() {
        return this.deferredPlans;
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @NotNull
    public RoutePlanner.Plan plan() throws IOException {
        ReusePlan pooled2;
        ReusePlan pooled1;
        ReusePlan reuseCallConnection;
        ReusePlan reusePlan = reuseCallConnection = this.planReuseCallConnection();
        if (reusePlan != null) {
            return reusePlan;
        }
        ReusePlan reusePlan2 = pooled1 = RealRoutePlanner.planReusePooledConnection$okhttp$default(this, null, null, 3, null);
        if (reusePlan2 != null) {
            return reusePlan2;
        }
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return this.getDeferredPlans().removeFirst();
        }
        ConnectPlan connect2 = this.planConnect$okhttp();
        ReusePlan reusePlan3 = pooled2 = this.planReusePooledConnection$okhttp(connect2, connect2.getRoutes$okhttp());
        if (reusePlan3 != null) {
            return reusePlan3;
        }
        return connect2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReusePlan planReuseCallConnection() {
        Socket socket;
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection candidate = realConnection;
        boolean healthy = candidate.isHealthy(this.doExtensiveHealthChecks);
        boolean noNewExchangesEvent = false;
        Lockable $this$withLock$iv = candidate;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            Socket socket2;
            boolean bl = false;
            if (!healthy) {
                noNewExchangesEvent = !candidate.getNoNewExchanges();
                candidate.setNoNewExchanges(true);
                socket2 = this.call.releaseConnectionNoEvents$okhttp();
            } else {
                socket2 = candidate.getNoNewExchanges() || !this.sameHostAndPort(candidate.route().address().url()) ? this.call.releaseConnectionNoEvents$okhttp() : null;
            }
            socket = socket2;
        }
        Socket toClose = socket;
        if (this.call.getConnection() != null) {
            if (!(toClose == null)) {
                throw new IllegalStateException("Check failed.");
            }
            return new ReusePlan(candidate);
        }
        Socket socket3 = toClose;
        if (socket3 != null) {
            _UtilJvmKt.closeQuietly(socket3);
        }
        this.call.getEventListener$okhttp().connectionReleased(this.call, candidate);
        candidate.getConnectionListener$okhttp().connectionReleased(candidate, this.call);
        if (toClose != null) {
            candidate.getConnectionListener$okhttp().connectionClosed(candidate);
        } else if (noNewExchangesEvent) {
            candidate.getConnectionListener$okhttp().noNewExchanges(candidate);
        }
        return null;
    }

    @NotNull
    public final ConnectPlan planConnect$okhttp() throws IOException {
        RouteSelector.Selection newRouteSelection;
        Route localNextRouteToTry = this.nextRouteToTry;
        if (localNextRouteToTry != null) {
            this.nextRouteToTry = null;
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, localNextRouteToTry, null, 2, null);
        }
        RouteSelector.Selection existingRouteSelection = this.routeSelection;
        if (existingRouteSelection != null && existingRouteSelection.hasNext()) {
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, existingRouteSelection.next(), null, 2, null);
        }
        RouteSelector newRouteSelector = this.routeSelector;
        if (newRouteSelector == null) {
            this.routeSelector = newRouteSelector = new RouteSelector(this.getAddress(), this.routeDatabase, this.call, this.fastFallback);
        }
        if (!newRouteSelector.hasNext()) {
            throw new IOException("exhausted all routes");
        }
        this.routeSelection = newRouteSelection = newRouteSelector.next();
        if (this.isCanceled()) {
            throw new IOException("Canceled");
        }
        return this.planConnectToRoute$okhttp(newRouteSelection.next(), newRouteSelection.getRoutes());
    }

    @Nullable
    public final ReusePlan planReusePooledConnection$okhttp(@Nullable ConnectPlan planToReplace, @Nullable List<Route> routes) {
        RealConnection realConnection = this.connectionPool.callAcquirePooledConnection$okhttp(this.doExtensiveHealthChecks, this.getAddress(), this.call, routes, planToReplace != null && planToReplace.isReady());
        if (realConnection == null) {
            return null;
        }
        RealConnection result = realConnection;
        if (planToReplace != null) {
            this.nextRouteToTry = planToReplace.getRoute();
            planToReplace.closeQuietly();
        }
        this.call.getEventListener$okhttp().connectionAcquired(this.call, result);
        result.getConnectionListener$okhttp().connectionAcquired(result, this.call);
        return new ReusePlan(result);
    }

    public static /* synthetic */ ReusePlan planReusePooledConnection$okhttp$default(RealRoutePlanner realRoutePlanner, ConnectPlan connectPlan, List list, int n, Object object) {
        if ((n & 1) != 0) {
            connectPlan = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planReusePooledConnection$okhttp(connectPlan, list);
    }

    @NotNull
    public final ConnectPlan planConnectToRoute$okhttp(@NotNull Route route, @Nullable List<Route> routes) throws IOException {
        Intrinsics.checkNotNullParameter(route, "route");
        if (route.address().sslSocketFactory() == null) {
            if (!route.address().connectionSpecs().contains(ConnectionSpec.CLEARTEXT)) {
                throw new UnknownServiceException("CLEARTEXT communication not enabled for client");
            }
            String host = route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted(host)) {
                throw new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy");
            }
        } else if (route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
        }
        Request tunnelRequest = route.requiresTunnel() ? this.createTunnelRequest(route) : null;
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.call, this, route, routes, 0, tunnelRequest, -1, false);
    }

    public static /* synthetic */ ConnectPlan planConnectToRoute$okhttp$default(RealRoutePlanner realRoutePlanner, Route route, List list, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planConnectToRoute$okhttp(route, list);
    }

    private final Request createTunnelRequest(Route route) throws IOException {
        Request proxyConnectRequest = new Request.Builder().url(route.address().url()).method("CONNECT", null).header("Host", _UtilJvmKt.toHostHeader(route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/5.3.2").build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request authenticatedRequest = route.address().proxyAuthenticator().authenticate(route, fakeAuthChallengeResponse);
        Request request = authenticatedRequest;
        if (request == null) {
            request = proxyConnectRequest;
        }
        return request;
    }

    @Override
    public boolean hasNext(@Nullable RealConnection failedConnection) {
        Route retryRoute;
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return true;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        if (failedConnection != null && (retryRoute = this.retryRoute(failedConnection)) != null) {
            this.nextRouteToTry = retryRoute;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        boolean bl = selection != null ? selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector localRouteSelector = routeSelector;
        return localRouteSelector.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute(RealConnection connection) {
        Route route;
        Lockable $this$withLock$iv = connection;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            route = connection.getRouteFailureCount$okhttp() != 0 ? null : (!connection.getNoNewExchanges() ? null : (!_UtilJvmKt.canReuseConnectionFor(connection.route().address().url(), this.getAddress().url()) ? null : connection.route()));
        }
        return route;
    }

    @Override
    public boolean sameHostAndPort(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter(url, "url");
        HttpUrl routeUrl = this.getAddress().url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual(url.host(), routeUrl.host());
    }
}

